

<?php $__env->startSection('title', 'Ethnic Groups · Admin'); ?>
<?php $__env->startSection('page-title', 'Ethnic Groups'); ?>
<?php $__env->startSection('wide', 'true'); ?>

<?php $__env->startSection('content'); ?>
    <section class="space-y-6">
        <div class="glass-card rounded-2xl border border-white/60 shadow-card p-6">
            <form method="GET" class="flex items-end gap-3">
                <div>
                    <label class="block text-xs text-slate-500">Filter by country</label>
                    <select name="country" class="rounded-xl border-slate-200">
                        <option value="">All</option>
                        <?php $__currentLoopData = $countries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $code): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($code); ?>" <?php if($country === $code): echo 'selected'; endif; ?>><?php echo e($code); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <button class="px-3 py-2 rounded-xl bg-primary text-white text-sm">Apply</button>
            </form>
        </div>

        <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
            <div class="rounded-2xl border border-slate-100 bg-white p-6">
                <h3 class="text-sm font-semibold text-ink mb-3">Create ethnic group</h3>
                <form method="POST" action="<?php echo e(route('admin.ethnic_groups.store')); ?>" class="space-y-3">
                    <?php echo csrf_field(); ?>
                    <div class="grid grid-cols-1 sm:grid-cols-2 gap-3">
                        <div>
                            <label class="block text-xs text-slate-500">Name</label>
                            <input name="name" class="w-full rounded-xl border-slate-200" required />
                        </div>
                        <div>
                            <label class="block text-xs text-slate-500">Country code</label>
                            <input name="country_code" class="w-full rounded-xl border-slate-200" placeholder="e.g. GH" required />
                        </div>
                        <div class="sm:col-span-2">
                            <label class="block text-xs text-slate-500">Languages (comma-separated)</label>
                            <input name="languages" class="w-full rounded-xl border-slate-200" placeholder="e.g. Twi, Fante" />
                        </div>
                        <div class="sm:col-span-2">
                            <label class="block text-xs text-slate-500">Description</label>
                            <textarea name="description" rows="3" class="w-full rounded-xl border-slate-200"></textarea>
                        </div>
                    </div>
                    <button class="px-4 py-2 rounded-xl bg-primary text-white text-sm">Create</button>
                </form>
            </div>

            <div class="rounded-2xl border border-slate-100 bg-white p-6 overflow-auto">
                <h3 class="text-sm font-semibold text-ink mb-3">Existing ethnic groups</h3>
                <table class="w-full text-sm">
                    <thead>
                        <tr class="text-left text-slate-500">
                            <th class="py-2">Name</th>
                            <th class="py-2">Country</th>
                            <th class="py-2">Languages</th>
                            <th class="py-2">Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $groups; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $g): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr class="border-t border-slate-100">
                            <td class="py-2 align-top">
                                <form method="POST" action="<?php echo e(route('admin.ethnic_groups.update', $g)); ?>" class="space-y-2">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('PATCH'); ?>
                                    <input name="name" value="<?php echo e($g->name); ?>" class="rounded-xl border-slate-200 w-full" />
                                    <textarea name="description" rows="2" class="rounded-xl border-slate-200 w-full" placeholder="Description"><?php echo e($g->description); ?></textarea>
                            </td>
                            <td class="py-2 align-top">
                                    <input name="country_code" value="<?php echo e($g->country_code); ?>" class="rounded-xl border-slate-200 w-24" />
                            </td>
                            <td class="py-2 align-top">
                                    <input name="languages" value="<?php echo e($g->languages); ?>" class="rounded-xl border-slate-200 w-full" />
                            </td>
                            <td class="py-2 align-top whitespace-nowrap">
                                    <button class="px-3 py-1.5 rounded-lg bg-primary text-white">Save</button>
                                </form>
                                <form method="POST" action="<?php echo e(route('admin.ethnic_groups.destroy', $g)); ?>" class="inline">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>
                                    <button class="px-3 py-1.5 rounded-lg bg-rose-50 text-rose-700" onclick="return confirm('Delete this group?')">Delete</button>
                                </form>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr><td colspan="4" class="py-4 text-slate-500">No ethnic groups yet.</td></tr>
                    <?php endif; ?>
                    </tbody>
                </table>
                <div class="mt-3"><?php echo e($groups->withQueryString()->links()); ?></div>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\familytree\api\resources\views/admin/ethnic-groups/index.blade.php ENDPATH**/ ?>