

<?php $__env->startSection('title', 'Families Directory · FamilyTree'); ?>
<?php $__env->startSection('page-title', 'Families Directory'); ?>

<?php $__env->startSection('sidebar-left'); ?>
    <div class="glass-card rounded-2xl border border-white/50 shadow-card p-5 space-y-4">
        <div>
            <h2 class="text-sm font-semibold text-slate-500 uppercase tracking-wide">Filters</h2>
            <p class="text-xs text-slate-400 mt-1">Browse families and discover new connections.</p>
        </div>
        <div class="flex items-center gap-3 text-sm text-slate-500">
            <span class="material-symbols-rounded text-primary">diversity_3</span>
            <span>Showing latest families first</span>
        </div>
        <div class="flex items-center gap-3 text-sm text-slate-500">
            <span class="material-symbols-rounded text-primary">search</span>
            <span>Search and advanced filters coming soon</span>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <section class="space-y-6">
        <div class="flex items-center justify-between">
            <h2 class="text-lg font-semibold text-slate-800">All Families</h2>
            <div class="flex items-center gap-3">
                <a href="<?php echo e(route('families.create')); ?>" class="inline-flex items-center gap-2 bg-primary text-white px-3 py-2 rounded-xl text-sm">
                    <span class="material-symbols-rounded text-base">add_circle</span>
                    Create family
                </a>
                <span class="text-xs text-slate-400">Page <?php echo e($families->currentPage()); ?> of <?php echo e($families->lastPage()); ?></span>
            </div>
        </div>

        <div class="grid grid-cols-1 sm:grid-cols-2 xl:grid-cols-3 gap-6">
            <?php $__empty_1 = true; $__currentLoopData = $families; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $family): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <article class="glass-card rounded-2xl border border-white/60 shadow-card overflow-hidden">
                    <div class="h-40 w-full bg-slate-100 overflow-hidden">
                        <?php ($cover = $family['cover'] ?: 'https://images.unsplash.com/photo-1524504388940-b1c1722653e1?auto=format&fit=crop&w=1200&q=60'); ?>
                        <img src="<?php echo e($cover); ?>" alt="<?php echo e($family['name']); ?> cover" class="h-full w-full object-cover" loading="lazy">
                    </div>
                    <div class="p-5 space-y-3">
                        <header class="flex items-start justify-between">
                            <h3 class="text-base font-semibold text-slate-800">
                                <?php if(auth()->guard()->check()): ?>
                                    <?php if(!empty($family['is_member']) || !empty($family['is_owner'])): ?>
                                        <a href="<?php echo e(route('families.tree', $family['id'])); ?>" class="hover:underline"><?php echo e($family['name']); ?></a>
                                    <?php else: ?>
                                        <?php echo e($family['name']); ?>

                                    <?php endif; ?>
                                <?php endif; ?>
                                <?php if(auth()->guard()->guest()): ?>
                                    <?php echo e($family['name']); ?>

                                <?php endif; ?>
                            </h3>
                            <div class="flex items-center gap-2 flex-wrap">
                                <?php if(auth()->guard()->check()): ?>
                                    <?php if((int)auth()->id() === (int)($family['owner_id'] ?? 0) || auth()->user()->can('invitations.manage')): ?>
                                        <a href="<?php echo e(route('families.invite', $family['id'])); ?>" class="inline-flex items-center gap-1 text-xs bg-primary/10 text-primary px-2 py-0.5 rounded-full hover:bg-primary/20">
                                            <span class="material-symbols-rounded text-sm">qr_code_2</span>
                                            Invite
                                        </a>
                                        <a href="<?php echo e(route('families.edit', $family['id'])); ?>" class="inline-flex items-center gap-1 text-xs bg-slate-100 text-slate-700 px-2 py-0.5 rounded-full hover:bg-slate-200">
                                            <span class="material-symbols-rounded text-sm">edit</span>
                                            Edit
                                        </a>
                                    <?php endif; ?>
                                <?php endif; ?>
                                <?php if(auth()->guard()->check()): ?>
                                    <?php if(!empty($family['is_member']) || !empty($family['is_owner'])): ?>
                                        <a href="<?php echo e(route('families.tree', $family['id'])); ?>" class="inline-flex items-center gap-1 text-xs bg-slate-100 text-slate-700 px-2 py-0.5 rounded-full hover:bg-slate-200">
                                            <span class="material-symbols-rounded text-sm">account_tree</span>
                                            Tree
                                        </a>
                                        <a href="<?php echo e(route('families.events.index', $family['id'])); ?>" class="inline-flex items-center gap-1 text-xs bg-slate-100 text-slate-700 px-2 py-0.5 rounded-full hover:bg-slate-200">
                                            <span class="material-symbols-rounded text-sm">event</span>
                                            Events
                                        </a>
                                        <a href="<?php echo e(route('families.announcements.index', $family['id'])); ?>" class="inline-flex items-center gap-1 text-xs bg-slate-100 text-slate-700 px-2 py-0.5 rounded-full hover:bg-slate-200">
                                            <span class="material-symbols-rounded text-sm">campaign</span>
                                            Announcements
                                        </a>
                                    <?php endif; ?>
                                <?php endif; ?>
                                <span class="text-xs bg-primary/10 text-primary px-2 py-0.5 rounded-full inline-flex items-center gap-1">
                                    <span class="material-symbols-rounded text-sm">groups</span>
                                    <?php echo e(number_format($family['members_count'])); ?>

                                </span>
                            </div>
                        </header>
                        <p class="text-sm text-slate-600 line-clamp-2"><?php echo e($family['description'] ?? '—'); ?></p>
                        <?php if(auth()->guard()->check()): ?>
                            <?php if(!empty($family['is_member']) || !empty($family['is_owner'])): ?>
                                <div>
                                    <a href="<?php echo e(route('families.tree', $family['id'])); ?>" class="inline-flex items-center gap-1 text-xs bg-primary/10 text-primary px-2 py-1 rounded-lg hover:bg-primary/20">
                                        <span class="material-symbols-rounded text-sm">account_tree</span>
                                        View Tree
                                    </a>
                                </div>
                            <?php endif; ?>
                        <?php endif; ?>
                        <div class="flex items-center justify-between text-xs text-slate-500">
                            <span class="inline-flex items-center gap-1">
                                <span class="material-symbols-rounded text-sm">person</span>
                                <?php echo e($family['owner'] ?? '—'); ?>

                            </span>
                            <span class="inline-flex items-center gap-1">
                                <span class="material-symbols-rounded text-sm">schedule</span>
                                <?php echo e($family['created_at'] ?? '—'); ?>

                            </span>
                        </div>
                    </div>
                </article>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <div class="col-span-full">
                    <div class="glass-card rounded-2xl border border-white/60 shadow-card p-10 text-center text-slate-500">
                        <p class="mb-4">No families found yet.</p>
                        <a href="<?php echo e(route('families.create')); ?>" class="inline-flex items-center gap-2 bg-primary text-white px-4 py-2 rounded-xl text-sm">
                            <span class="material-symbols-rounded text-base">diversity_3</span>
                            Create your first family
                        </a>
                    </div>
                </div>
            <?php endif; ?>
        </div>

        <div class="border-t border-slate-200/60 pt-4">
            <?php echo e($families->withQueryString()->onEachSide(1)->links()); ?>

        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('sidebar-right'); ?>
    <div class="glass-card rounded-2xl border border-white/50 shadow-card p-6 space-y-4">
        <header>
            <h2 class="text-sm font-semibold text-slate-500 uppercase tracking-wide">People you may know</h2>
            <p class="text-xs text-slate-400">Recently added members</p>
        </header>
        <ul class="space-y-3">
            <?php $__currentLoopData = $people; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $person): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <li class="flex items-center gap-3">
                    <img src="<?php echo e($person['photo'] ?? 'https://ui-avatars.com/api/?name='.urlencode($person['name'] ?? 'Member')); ?>" alt="<?php echo e($person['name'] ?? 'Member'); ?>" class="h-10 w-10 rounded-full object-cover" loading="lazy">
                    <div>
                        <p class="text-sm font-medium text-slate-700"><?php echo e($person['name']); ?></p>
                        <?php if(!empty($person['bio'])): ?>
                            <p class="text-xs text-slate-400 line-clamp-1"><?php echo e($person['bio']); ?></p>
                        <?php endif; ?>
                    </div>
                </li>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </ul>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('head'); ?>
    <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Material+Symbols+Rounded:opsz,wght,FILL,GRAD@24,400,0,0" />
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\familytree\api\resources\views/families/index.blade.php ENDPATH**/ ?>