

<?php $__env->startSection('title', 'Analytics · Admin · FamilyTree'); ?>
<?php $__env->startSection('page-title', 'Traffic Analytics'); ?>
<?php $__env->startSection('wide', 'true'); ?>

<?php $__env->startSection('content'); ?>
<section class="space-y-6">
    <form method="GET" class="glass-card rounded-2xl border border-white/60 shadow-card p-6 grid md:grid-cols-4 gap-4">
        <div>
            <label class="block text-xs text-slate-500 mb-1">From</label>
            <input type="date" name="from" value="<?php echo e(request('from', $from->toDateString())); ?>" class="w-full rounded-xl border border-slate-200 px-3 py-2">
        </div>
        <div>
            <label class="block text-xs text-slate-500 mb-1">To</label>
            <input type="date" name="to" value="<?php echo e(request('to', $to->toDateString())); ?>" class="w-full rounded-xl border border-slate-200 px-3 py-2">
        </div>
        <div class="md:col-span-2 flex items-end justify-end">
            <button class="px-4 py-2 rounded-xl bg-primary text-white">Apply</button>
        </div>
    </form>

    <div class="grid gap-6 md:grid-cols-2 xl:grid-cols-4">
        <div class="rounded-2xl border border-slate-100 bg-white p-6">
            <div class="text-xs uppercase tracking-widest text-slate-400">Visits</div>
            <div class="text-2xl font-semibold mt-1"><?php echo e(number_format($totals['visits'])); ?></div>
        </div>
        <div class="rounded-2xl border border-slate-100 bg-white p-6">
            <div class="text-xs uppercase tracking-widest text-slate-400">Unique Sessions</div>
            <div class="text-2xl font-semibold mt-1"><?php echo e(number_format($totals['unique_sessions'])); ?></div>
        </div>
        <div class="rounded-2xl border border-slate-100 bg-white p-6">
            <div class="text-xs uppercase tracking-widest text-slate-400">Authenticated Users</div>
            <div class="text-2xl font-semibold mt-1"><?php echo e(number_format($totals['unique_users'])); ?></div>
        </div>
    </div>

    <div class="grid gap-6 xl:grid-cols-2">
        <div class="rounded-2xl border border-slate-100 bg-white p-6">
            <div class="text-sm font-semibold text-slate-800 mb-2">Daily Visits</div>
            <div class="grid grid-cols-7 gap-1 items-end h-40">
                <?php $__currentLoopData = $daily; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="bg-primary/20" style="height: <?php echo e(max(4, $row['value']) * 2); ?>px" title="<?php echo e($row['label']); ?>: <?php echo e($row['value']); ?>"></div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
            <div class="mt-2 flex justify-between text-xs text-slate-500">
                <?php if(count($daily)): ?>
                    <span><?php echo e($daily->first()['label']); ?></span>
                    <span><?php echo e($daily->last()['label']); ?></span>
                <?php endif; ?>
            </div>
        </div>
        <div class="rounded-2xl border border-slate-100 bg-white p-6">
            <div class="text-sm font-semibold text-slate-800 mb-2">Top Pages</div>
            <ul class="space-y-2">
                <?php $__currentLoopData = $topPages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li class="flex justify-between text-sm"><span class="truncate max-w-[70%]"><?php echo e($row->path); ?></span><span class="text-slate-500"><?php echo e($row->total); ?></span></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        </div>
    </div>

    <div class="grid gap-6 xl:grid-cols-3">
        <div class="rounded-2xl border border-slate-100 bg-white p-6">
            <div class="text-sm font-semibold text-slate-800 mb-2">Top Countries</div>
            <ul class="space-y-2">
                <?php $__currentLoopData = $topCountries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li class="flex justify-between text-sm"><span><?php echo e($row->country); ?></span><span class="text-slate-500"><?php echo e($row->total); ?></span></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        </div>
        <div class="rounded-2xl border border-slate-100 bg-white p-6">
            <div class="text-sm font-semibold text-slate-800 mb-2">Devices</div>
            <ul class="space-y-2">
                <?php $__currentLoopData = $devices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li class="flex justify-between text-sm"><span><?php echo e($row->device ?? 'Unknown'); ?></span><span class="text-slate-500"><?php echo e($row->total); ?></span></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        </div>
        <div class="rounded-2xl border border-slate-100 bg-white p-6">
            <div class="text-sm font-semibold text-slate-800 mb-2">Browsers</div>
            <ul class="space-y-2">
                <?php $__currentLoopData = $browsers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li class="flex justify-between text-sm"><span><?php echo e($row->browser ?? 'Unknown'); ?></span><span class="text-slate-500"><?php echo e($row->total); ?></span></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        </div>
    </div>

    <div class="grid gap-6 xl:grid-cols-2">
        <div class="rounded-2xl border border-slate-100 bg-white p-6">
            <div class="text-sm font-semibold text-slate-800 mb-2">Recent Visits</div>
            <div class="overflow-x-auto">
                <table class="min-w-full text-sm">
                    <thead>
                        <tr class="text-left text-slate-500 border-b border-slate-100">
                            <th class="py-2 pr-4">Time</th>
                            <th class="py-2 pr-4">User</th>
                            <th class="py-2 pr-4">Path</th>
                            <th class="py-2 pr-4">IP</th>
                            <th class="py-2 pr-4">Country/City</th>
                            <th class="py-2 pr-4">Device</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $recentVisits; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $v): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr class="border-b border-slate-100">
                                <td class="py-2 pr-4"><?php echo e($v->created_at->diffForHumans()); ?></td>
                                <td class="py-2 pr-4"><?php echo e($v->user?->name ?? 'Guest'); ?></td>
                                <td class="py-2 pr-4"><?php echo e($v->path); ?></td>
                                <td class="py-2 pr-4"><?php echo e($v->ip); ?></td>
                                <td class="py-2 pr-4"><?php echo e($v->country ?? '—'); ?> / <?php echo e($v->city ?? '—'); ?></td>
                                <td class="py-2 pr-4"><?php echo e($v->device ?? '—'); ?> • <?php echo e($v->browser ?? ''); ?></td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
            <div class="mt-3"><?php echo e($recentVisits->links()); ?></div>
        </div>
        <div class="rounded-2xl border border-slate-100 bg-white p-6">
            <div class="text-sm font-semibold text-slate-800 mb-2">Recent Events</div>
            <div class="overflow-x-auto">
                <table class="min-w-full text-sm">
                    <thead>
                        <tr class="text-left text-slate-500 border-b border-slate-100">
                            <th class="py-2 pr-4">Time</th>
                            <th class="py-2 pr-4">User</th>
                            <th class="py-2 pr-4">Event</th>
                            <th class="py-2 pr-4">Properties</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $recentEvents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $e): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr class="border-b border-slate-100">
                                <td class="py-2 pr-4"><?php echo e($e->created_at->diffForHumans()); ?></td>
                                <td class="py-2 pr-4"><?php echo e($e->user?->name ?? 'Guest'); ?></td>
                                <td class="py-2 pr-4"><?php echo e($e->name); ?></td>
                                <td class="py-2 pr-4 text-slate-500">
                                    <code class="text-xs"><?php echo e(json_encode($e->properties)); ?></code>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
            <div class="mt-3"><?php echo e($recentEvents->links()); ?></div>
        </div>
    </div>
</section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\familytree\api\resources\views/admin/analytics/index.blade.php ENDPATH**/ ?>