<?php

use App\Http\Controllers\AnalyticsController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\FamilyDirectoryController;
use App\Http\Controllers\SubscriptionOverviewController;
use App\Http\Controllers\FamilyTreeController;
use App\Http\Controllers\FamilyRelationshipController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\SettingsController;
use App\Http\Controllers\FamilyEventController;
use App\Http\Controllers\FamilyAnnouncementController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', DashboardController::class)->name('dashboard');

Route::middleware('web')->group(function () {
    // Public marketing page: How It Works
    Route::get('/how-it-works', function () {
        return view('marketing.how_it_works');
    })->name('how_it_works');
    Route::get('/families', [FamilyDirectoryController::class, 'index'])->name('families.index');
    Route::get('/families/create', [FamilyDirectoryController::class, 'create'])->middleware('auth')->name('families.create');
    Route::post('/families', [FamilyDirectoryController::class, 'store'])->middleware('auth')->name('families.store');
    Route::get('/families/{family}/edit', [FamilyDirectoryController::class, 'edit'])->middleware('auth')->name('families.edit');
    Route::patch('/families/{family}', [FamilyDirectoryController::class, 'update'])->middleware('auth')->name('families.update');
    Route::get('/families/{family}/tree', [FamilyTreeController::class, 'show'])->middleware('auth')->name('families.tree');
    Route::get('/families/{family}/invite', [FamilyDirectoryController::class, 'invite'])->middleware('auth')->name('families.invite');
    Route::post('/families/{family}/invite', [FamilyDirectoryController::class, 'sendInvite'])->middleware('auth')->name('families.invite.send');
    // Family relationships management (web UI)
    Route::get('/families/{family}/relationships', [FamilyRelationshipController::class, 'index'])->middleware('auth')->name('families.relationships.manage.index');
    Route::post('/families/{family}/relationships', [FamilyRelationshipController::class, 'store'])->middleware('auth')->name('families.relationships.manage.store');
    Route::delete('/families/{family}/relationships/{relationship}', [FamilyRelationshipController::class, 'destroy'])->middleware('auth')->name('families.relationships.manage.destroy');
    // Family events
    Route::get('/families/{family}/events', [FamilyEventController::class, 'index'])->middleware('auth')->name('families.events.index');
    Route::post('/families/{family}/events', [FamilyEventController::class, 'store'])->middleware('auth')->name('families.events.store');
    Route::put('/families/{family}/events/{event}', [FamilyEventController::class, 'update'])->middleware('auth')->name('families.events.update');
    Route::delete('/families/{family}/events/{event}', [FamilyEventController::class, 'destroy'])->middleware('auth')->name('families.events.destroy');
    Route::post('/families/{family}/events/permissions', [FamilyEventController::class, 'updatePermissions'])->middleware('auth')->name('families.events.permissions.update');
    Route::post('/families/{family}/events/settings', [FamilyEventController::class, 'updateReminderSettings'])->middleware('auth')->name('families.events.settings.update');
    // Family announcements
    Route::get('/families/{family}/announcements', [FamilyAnnouncementController::class, 'index'])->middleware('auth')->name('families.announcements.index');
    Route::post('/families/{family}/announcements', [FamilyAnnouncementController::class, 'store'])->middleware('auth')->name('families.announcements.store');
    Route::put('/families/{family}/announcements/{announcement}', [FamilyAnnouncementController::class, 'update'])->middleware('auth')->name('families.announcements.update');
    Route::delete('/families/{family}/announcements/{announcement}', [FamilyAnnouncementController::class, 'destroy'])->middleware('auth')->name('families.announcements.destroy');
    Route::post('/families/{family}/announcements/permissions', [FamilyAnnouncementController::class, 'updatePermissions'])->middleware('auth')->name('families.announcements.permissions.update');
    Route::get('/subscriptions', [SubscriptionOverviewController::class, 'index'])->name('subscriptions');
    Route::get('/analytics', [AnalyticsController::class, 'index'])->name('analytics');
    Route::get('/settings', [SettingsController::class, 'index'])->middleware('auth')->name('settings');
    Route::post('/settings/profile', [SettingsController::class, 'updateProfile'])->middleware('auth')->name('settings.profile.update');
});

Route::middleware('web')->group(function () {
    Route::get('/login', [\App\Http\Controllers\AuthSessionController::class, 'create'])->name('login');
    Route::post('/login', [\App\Http\Controllers\AuthSessionController::class, 'store'])->name('login.store');
    Route::post('/logout', [\App\Http\Controllers\AuthSessionController::class, 'destroy'])->name('logout');

    Route::get('/register', [\App\Http\Controllers\AuthSessionController::class, 'createRegister'])->name('register');
    Route::post('/register', [\App\Http\Controllers\AuthSessionController::class, 'register'])->name('register.store');

    // Analytics client events ingestion
    Route::post('/analytics/event', [\App\Http\Controllers\AnalyticsEventController::class, 'store'])
        ->middleware(['throttle:60,1'])
        ->name('analytics.event');

    Route::get('/admin', [\App\Http\Controllers\AdminController::class, 'index'])->middleware(['auth','role:admin'])->name('admin.index');

    Route::prefix('admin')->middleware(['auth','role:admin'])->group(function () {
        // Locations management
        Route::get('/locations', [\App\Http\Controllers\Admin\LocationsController::class, 'index'])->name('admin.locations.index');
        Route::post('/locations', [\App\Http\Controllers\Admin\LocationsController::class, 'storeCountry'])->name('admin.locations.store');
        Route::get('/locations/{country}', [\App\Http\Controllers\Admin\LocationsController::class, 'showCountry'])->name('admin.locations.show');
        Route::patch('/locations/{country}', [\App\Http\Controllers\Admin\LocationsController::class, 'updateCountry'])->name('admin.locations.update');
        Route::delete('/locations/{country}', [\App\Http\Controllers\Admin\LocationsController::class, 'deleteCountry'])->name('admin.locations.delete');

        Route::post('/locations/{country}/regions', [\App\Http\Controllers\Admin\LocationsController::class, 'addRegion'])->name('admin.locations.region.add');
        Route::delete('/locations/{country}/regions', [\App\Http\Controllers\Admin\LocationsController::class, 'deleteRegion'])->name('admin.locations.region.delete');

        Route::post('/locations/{country}/districts', [\App\Http\Controllers\Admin\LocationsController::class, 'addDistrict'])->name('admin.locations.district.add');
        Route::delete('/locations/{country}/districts', [\App\Http\Controllers\Admin\LocationsController::class, 'deleteDistrict'])->name('admin.locations.district.delete');

        Route::post('/locations/{country}/towns', [\App\Http\Controllers\Admin\LocationsController::class, 'addTown'])->name('admin.locations.town.add');
        Route::delete('/locations/{country}/towns', [\App\Http\Controllers\Admin\LocationsController::class, 'deleteTown'])->name('admin.locations.town.delete');

        // Users management
        Route::get('/users', [\App\Http\Controllers\Admin\UsersController::class, 'index'])->name('admin.users.index');
        Route::patch('/users/{user}/roles', [\App\Http\Controllers\Admin\UsersController::class, 'updateRoles'])->name('admin.users.roles.update');

        // Analytics dashboard
        Route::get('/analytics', [\App\Http\Controllers\Admin\TrafficAnalyticsController::class, 'index'])->name('admin.analytics.index');

        // Ethnic groups and clans management
        Route::get('/ethnic-groups', [\App\Http\Controllers\Admin\EthnicGroupController::class, 'index'])->name('admin.ethnic_groups.index');
        Route::post('/ethnic-groups', [\App\Http\Controllers\Admin\EthnicGroupController::class, 'store'])->name('admin.ethnic_groups.store');
        Route::patch('/ethnic-groups/{ethnicGroup}', [\App\Http\Controllers\Admin\EthnicGroupController::class, 'update'])->name('admin.ethnic_groups.update');
        Route::delete('/ethnic-groups/{ethnicGroup}', [\App\Http\Controllers\Admin\EthnicGroupController::class, 'destroy'])->name('admin.ethnic_groups.destroy');

        Route::get('/clans', [\App\Http\Controllers\Admin\ClanController::class, 'index'])->name('admin.clans.index');
        Route::post('/clans', [\App\Http\Controllers\Admin\ClanController::class, 'store'])->name('admin.clans.store');
        Route::patch('/clans/{clan}', [\App\Http\Controllers\Admin\ClanController::class, 'update'])->name('admin.clans.update');
        Route::delete('/clans/{clan}', [\App\Http\Controllers\Admin\ClanController::class, 'destroy'])->name('admin.clans.destroy');

        // Notifications & reminders admin
        Route::get('/notifications', [\App\Http\Controllers\Admin\NotificationsController::class, 'index'])->name('admin.notifications.index');
        Route::post('/notifications/settings', [\App\Http\Controllers\Admin\NotificationsController::class, 'updateSettings'])->name('admin.notifications.settings.update');
        Route::post('/notifications/bulk', [\App\Http\Controllers\Admin\NotificationsController::class, 'sendBulk'])->name('admin.notifications.bulk.send');
    });

    // Authenticated features: post composer, uploads, and people search
    Route::middleware('auth')->group(function () {
        // Wall posts
        Route::get('/families/{family}/posts', [\App\Http\Controllers\FamilyWallPostController::class, 'index'])->name('families.posts.index');
        Route::post('/families/{family}/posts', [\App\Http\Controllers\FamilyWallPostController::class, 'store'])->name('families.posts.store');
        Route::get('/families/{family}/posts/{wallPost}', [\App\Http\Controllers\FamilyWallPostController::class, 'show'])->name('families.posts.show');

        // Post comments
        Route::get('/families/{family}/posts/{wallPost}/comments', [\App\Http\Controllers\FamilyWallPostCommentController::class, 'index'])->name('families.posts.comments.index');
        Route::post('/families/{family}/posts/{wallPost}/comments', [\App\Http\Controllers\FamilyWallPostCommentController::class, 'store'])->name('families.posts.comments.store');
        Route::patch('/families/{family}/posts/{wallPost}/comments/{comment}', [\App\Http\Controllers\FamilyWallPostCommentController::class, 'update'])->name('families.posts.comments.update');
        Route::delete('/families/{family}/posts/{wallPost}/comments/{comment}', [\App\Http\Controllers\FamilyWallPostCommentController::class, 'destroy'])->name('families.posts.comments.delete');

        // Post reactions
        Route::get('/families/{family}/posts/{wallPost}/reactions', [\App\Http\Controllers\FamilyWallPostReactionController::class, 'index'])->name('families.posts.reactions.index');
        Route::post('/families/{family}/posts/{wallPost}/reactions', [\App\Http\Controllers\FamilyWallPostReactionController::class, 'store'])->name('families.posts.reactions.store');
        Route::delete('/families/{family}/posts/{wallPost}/reactions', [\App\Http\Controllers\FamilyWallPostReactionController::class, 'destroy'])->name('families.posts.reactions.delete');

        // People search for mentions
        Route::get('/people/search', \App\Http\Controllers\PeopleSearchController::class)->name('people.search');

        // Media uploads
        Route::post('/uploads', \App\Http\Controllers\UploadController::class)->name('uploads.store');

        // Notifications
        Route::get('/notifications', [\App\Http\Controllers\NotificationController::class, 'index'])->name('notifications.index');
        Route::post('/notifications/read', [\App\Http\Controllers\NotificationController::class, 'markAsRead'])->name('notifications.read');

        // Ethnic lookup (for create family form)
        Route::get('/ethnic/groups', [\App\Http\Controllers\EthnicLookupController::class, 'groups'])->name('ethnic.groups');
        Route::get('/ethnic/clans', [\App\Http\Controllers\EthnicLookupController::class, 'clans'])->name('ethnic.clans');
    });
});

// Fallback file server for public storage when symlink is unavailable
Route::get('/storage/{path}', function ($path) {
    abort_unless(\Illuminate\Support\Facades\Storage::disk('public')->exists($path), 404);
    return \Illuminate\Support\Facades\Storage::disk('public')->response($path);
})->where('path', '.*');

