<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\FamilyController;
use App\Http\Controllers\FamilyWallPostController;
use App\Http\Controllers\InvitationController;
use App\Http\Controllers\PlanController;
use App\Http\Controllers\PersonController;
use App\Http\Controllers\FamilySubscriptionController;
use App\Http\Controllers\FamilyPaymentMethodController;
use App\Http\Controllers\RelationshipController;
use App\Http\Controllers\WebhookController;
use App\Http\Controllers\FamilyWallPostCommentController;
use App\Http\Controllers\FamilyWallPostReactionController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/
Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});

Route::prefix('auth')->group(function () {
    Route::post('/register', [AuthController::class, 'register']);
    Route::post('/login', [AuthController::class, 'login']);

    Route::middleware('auth:sanctum')->group(function () {
        Route::get('/me', [AuthController::class, 'me']);
        Route::post('/logout', [AuthController::class, 'logout']);
    });
});

Route::get('plans', [PlanController::class, 'index']);
Route::post('invitations/accept', [InvitationController::class, 'accept']);
Route::post('webhooks/{provider}', [WebhookController::class, 'handle']);

Route::middleware('auth:sanctum')->group(function () {
    Route::apiResource('families', FamilyController::class);
    Route::apiResource('families.relationships', RelationshipController::class)->except(['show']);
    Route::apiResource('families.invitations', InvitationController::class)->only(['index', 'store', 'destroy']);
    Route::apiResource('families.wall-posts', FamilyWallPostController::class)->except(['show', 'edit', 'create']);
    Route::apiResource('families.wall-posts.comments', FamilyWallPostCommentController::class)->except(['show', 'edit', 'create']);
    Route::get('families/{family}/wall-posts/{wall_post}/reactions', [FamilyWallPostReactionController::class, 'index']);
    Route::post('families/{family}/wall-posts/{wall_post}/reactions', [FamilyWallPostReactionController::class, 'store']);
    Route::delete('families/{family}/wall-posts/{wall_post}/reactions', [FamilyWallPostReactionController::class, 'destroy']);

    Route::post('families/{family}/subscription/preview', [FamilySubscriptionController::class, 'preview']);
    Route::post('families/{family}/subscription', [FamilySubscriptionController::class, 'store']);
    Route::patch('families/{family}/subscription/{subscription}', [FamilySubscriptionController::class, 'update']);
    Route::post('families/{family}/subscription/{subscription}/cancel', [FamilySubscriptionController::class, 'cancel']);
    Route::post('families/{family}/subscription/{subscription}/resume', [FamilySubscriptionController::class, 'resume']);
    Route::get('families/{family}/subscription/{subscription}/invoices', [FamilySubscriptionController::class, 'invoices']);

    Route::get('families/{family}/payment-methods', [FamilyPaymentMethodController::class, 'index']);
    Route::post('families/{family}/payment-methods', [FamilyPaymentMethodController::class, 'store']);
    Route::post('families/{family}/payment-methods/{paymentMethod}/default', [FamilyPaymentMethodController::class, 'setDefault']);
    Route::delete('families/{family}/payment-methods/{paymentMethod}', [FamilyPaymentMethodController::class, 'destroy']);

    Route::post('people/{person}/memorialize', [PersonController::class, 'memorialize']);
    Route::apiResource('people', PersonController::class);
});

