@extends('layouts.app')

@section('title', 'Settings · FamilyTree')
@section('page-title', 'Settings')

@section('sidebar-left')
    <nav class="glass-card rounded-2xl border border-white/50 shadow-card p-5 space-y-2 text-sm text-slate-600">
        <a href="#profile" class="block px-3 py-2 rounded-xl hover:text-primary">Profile</a>
        <a href="#security" class="block px-3 py-2 rounded-xl hover:text-primary">Security</a>
        <a href="#notifications" class="block px-3 py-2 rounded-xl hover:text-primary">Notifications</a>
        <a href="#billing" class="block px-3 py-2 rounded-xl hover:text-primary">Billing</a>
    </nav>
@endsection

@section('content')
    <section id="profile" class="space-y-6">
        <div class="glass-card rounded-2xl border border-white/60 shadow-card p-6">
            <header class="mb-4">
                <h2 class="text-lg font-semibold text-slate-800">Profile</h2>
                <p class="text-sm text-slate-500">Update your basic information</p>
            </header>
            @if(session('status'))
                <div class="mb-4 text-sm text-emerald-700 bg-emerald-50 border border-emerald-200 rounded-xl px-3 py-2">{{ session('status') }}</div>
            @endif
            <form method="POST" action="{{ route('settings.profile.update') }}" class="grid grid-cols-1 md:grid-cols-2 gap-4">
                @csrf
                <div>
                    <label class="block text-sm text-slate-600 mb-1">First Name</label>
                    <input name="first_name" value="{{ old('first_name', $person->first_name ?? '') }}" type="text" class="w-full rounded-xl border-slate-200 focus:border-primary focus:ring-primary" placeholder="First name">
                </div>
                <div>
                    <label class="block text-sm text-slate-600 mb-1">Last Name</label>
                    <input name="last_name" value="{{ old('last_name', $person->last_name ?? '') }}" type="text" class="w-full rounded-xl border-slate-200 focus:border-primary focus:ring-primary" placeholder="Last name">
                </div>
                <div class="md:col-span-2">
                    <label class="block text-sm text-slate-600 mb-1">Bio</label>
                    <textarea name="bio" rows="3" class="w-full rounded-xl border-slate-200 focus:border-primary focus:ring-primary" placeholder="A short bio...">{{ old('bio', $person->bio ?? '') }}</textarea>
                </div>
                <div>
                    <label class="block text-sm text-slate-600 mb-1">Profile Photo URL</label>
                    <input name="photo_url" value="{{ old('photo_url', $person->photo_url ?? '') }}" type="url" class="w-full rounded-xl border-slate-200 focus:border-primary focus:ring-primary" placeholder="https://...">
                </div>
                <div>
                    <label class="block text-sm text-slate-600 mb-1">Birth Date</label>
                    @php($birthVal = '')
                    @if(!empty($person?->birth_date))
                        @php($birthVal = is_object($person->birth_date) && method_exists($person->birth_date,'format') ? $person->birth_date->format('Y-m-d') : (is_string($person->birth_date) ? $person->birth_date : ''))
                    @endif
                    <input name="birth_date" value="{{ old('birth_date', $birthVal) }}" type="date" class="w-full rounded-xl border-slate-200 focus:border-primary focus:ring-primary">
                </div>
                <div class="md:col-span-2">
                    <button type="submit" class="inline-flex items-center gap-2 bg-primary text-white px-4 py-2 rounded-xl">
                        <span class="material-symbols-rounded">save</span>
                        Save changes
                    </button>
                </div>
            </form>
        </div>

        <div id="security" class="glass-card rounded-2xl border border-white/60 shadow-card p-6">
            <header class="mb-4">
                <h2 class="text-lg font-semibold text-slate-800">Security</h2>
                <p class="text-sm text-slate-500">Password and session settings</p>
            </header>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                <div>
                    <label class="block text-sm text-slate-600 mb-1">New Password</label>
                    <input type="password" class="w-full rounded-xl border-slate-200 focus:border-primary focus:ring-primary" placeholder="••••••••">
                </div>
                <div>
                    <label class="block text-sm text-slate-600 mb-1">Confirm Password</label>
                    <input type="password" class="w-full rounded-xl border-slate-200 focus:border-primary focus:ring-primary" placeholder="••••••••">
                </div>
            </div>
            <div class="mt-4">
                <button type="button" class="inline-flex items-center gap-2 bg-primary text-white px-4 py-2 rounded-xl">
                    <span class="material-symbols-rounded">key</span>
                    Update password
                </button>
            </div>
        </div>

        <div id="notifications" class="glass-card rounded-2xl border border-white/60 shadow-card p-6">
            <header class="mb-4">
                <h2 class="text-lg font-semibold text-slate-800">Notifications</h2>
                <p class="text-sm text-slate-500">Email and SMS preferences</p>
            </header>
            <div class="space-y-3 text-sm text-slate-600">
                <label class="flex items-center gap-3">
                    <input type="checkbox" class="rounded border-slate-300 text-primary focus:ring-primary" checked>
                    Email me important updates
                </label>
                <label class="flex items-center gap-3">
                    <input type="checkbox" class="rounded border-slate-300 text-primary focus:ring-primary">
                    SMS notifications for events
                </label>
            </div>
        </div>

        <div id="billing" class="glass-card rounded-2xl border border-white/60 shadow-card p-6">
            <header class="mb-4">
                <h2 class="text-lg font-semibold text-slate-800">Billing</h2>
                <p class="text-sm text-slate-500">Manage your subscription</p>
            </header>
            <div class="text-sm text-slate-600">
                To manage billing, visit the Subscriptions page.
            </div>
        </div>
    </section>
@endsection

@push('head')
    <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Material+Symbols+Rounded:opsz,wght,FILL,GRAD@24,400,0,0" />
@endpush
