<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>@yield('title', 'FamilyTree')</title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    @vite(['resources/css/app.css', 'resources/js/app.js'])
    @stack('head')
</head>
<body class="bg-muted min-h-screen text-slate-800">
    <a href="#main" class="sr-only focus:not-sr-only focus:absolute focus:z-50 focus:left-4 focus:top-4 focus:bg-primary focus:text-white focus:px-5 focus:py-2 focus:rounded-full">Skip to main content</a>
    <div class="min-h-screen flex flex-col">
        <header class="bg-white/90 backdrop-blur border-b border-slate-100 sticky top-0 z-40" role="banner">
            <div class="max-w-7xl mx-auto px-4 lg:px-6">
                <div class="flex items-center justify-between h-16" aria-label="Primary navigation">
                    <div class="flex items-center gap-3">
                        <div class="h-10 w-10 rounded-full bg-primary/10 text-primary flex items-center justify-center font-semibold" aria-hidden="true">FT</div>
                        <div>
                            <p class="text-xs uppercase tracking-widest text-slate-400">FamilyTree</p>
                            <h1 class="text-lg font-semibold text-ink">@yield('page-title', 'Dashboard')</h1>
                        </div>
                    </div>
                    <div class="hidden md:flex items-center gap-4 text-slate-500">
                        <nav dusk="desktop-nav" class="flex items-center gap-6 text-sm font-medium" aria-label="Main menu">
                            @php(
                                $navItems = [
                                    ['route' => 'dashboard', 'label' => 'Home'],
                                    ['route' => 'families.index', 'label' => 'Families'],
                                ]
                            )
                            @if(auth()->check() && auth()->user()->hasRole('admin'))
                                @php($navItems[] = ['route' => 'subscriptions', 'label' => 'Subscriptions'])
                                @php($navItems[] = ['route' => 'admin.analytics.index', 'label' => 'Analytics'])
                                @php($navItems[] = ['route' => 'admin.notifications.index', 'label' => 'Notifications'])
                                @php($navItems[] = ['route' => 'admin.index', 'label' => 'Admin'])
                            @endif
                            @php($navItems[] = ['route' => 'settings', 'label' => 'Settings'])
                            @foreach($navItems as $item)
                                <a href="{{ route($item['route']) }}"
                                   dusk="nav-{{ $item['route'] }}"
                                   @class(['relative inline-flex items-center gap-2 rounded-full px-3 py-2 transition focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-primary/60',
                                           'text-primary bg-primary/10' => request()->routeIs($item['route']),
                                           'hover:text-primary' => !request()->routeIs($item['route'])])
                                   aria-current="{{ request()->routeIs($item['route']) ? 'page' : 'false' }}">
                                    {{ $item['label'] }}
                                </a>
                            @endforeach
                        </nav>
                        @auth
                            @php($unread = auth()->user()->unreadNotifications()->count())
                            <div class="relative" id="notificationsContainer">
                                <button id="notificationsButton" type="button" class="relative rounded-full p-2 text-slate-500 hover:text-primary focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-primary/60" aria-label="View notifications" aria-haspopup="menu" aria-expanded="false" aria-controls="notificationsMenu" data-analytics="notifications_open">
                                    <span class="material-symbols-rounded" aria-hidden="true">notifications</span>
                                    @if($unread > 0)
                                        <span id="notificationsBadge" class="absolute -top-1.5 -right-1.5 bg-primary text-white text-[10px] rounded-full min-w-4 h-4 px-1 flex items-center justify-center">{{ $unread > 9 ? '9+' : $unread }}</span>
                                    @else
                                        <span id="notificationsBadge" class="hidden absolute -top-1.5 -right-1.5 bg-primary text-white text-[10px] rounded-full min-w-4 h-4 px-1 flex items-center justify-center">0</span>
                                    @endif
                                </button>
                                <div id="notificationsMenu" role="menu" aria-labelledby="notificationsButton" class="hidden absolute right-0 mt-2 w-80 origin-top-right rounded-xl border border-slate-200 bg-white py-2 shadow-lg focus:outline-none z-50">
                                    <div class="px-4 py-2 flex items-center justify-between">
                                        <div class="text-sm font-medium text-slate-700">Notifications</div>
                                        <button id="markAllReadBtn" type="button" class="text-xs font-semibold text-primary hover:underline">Mark all as read</button>
                                    </div>
                                    <div class="max-h-80 overflow-auto" id="notificationsList">
                                        <div class="px-4 py-4 text-sm text-slate-500">Loading…</div>
                                    </div>
                                </div>
                            </div>
                            <div class="relative" aria-label="Account menu">
                                <button id="accountMenuButton" type="button" class="flex items-center gap-2 rounded-full focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-primary/60 px-2 py-1 text-slate-700 hover:text-primary" aria-haspopup="menu" aria-expanded="false" aria-controls="accountMenu">
                                    <span class="text-sm font-medium hidden lg:block">{{ auth()->user()->name }}</span>
                                    <img src="{{ auth()->user()?->person?->photo_url ?? 'https://ui-avatars.com/api/?name='.urlencode(auth()->user()->name) }}" alt="{{ auth()->user()->name }} avatar" class="h-10 w-10 rounded-full object-cover">
                                    <svg class="h-4 w-4 text-slate-400" viewBox="0 0 20 20" fill="currentColor" aria-hidden="true"><path fill-rule="evenodd" d="M5.23 7.21a.75.75 0 011.06.02L10 10.94l3.71-3.71a.75.75 0 111.06 1.06l-4.24 4.24a.75.75 0 01-1.06 0L5.21 8.29a.75.75 0 01.02-1.08z" clip-rule="evenodd"/></svg>
                                </button>
                                <div id="accountMenu" role="menu" aria-labelledby="accountMenuButton" class="hidden absolute right-0 mt-2 w-56 origin-top-right rounded-xl border border-slate-200 bg-white py-2 shadow-lg focus:outline-none z-50">
                                    <div class="px-3 py-2 text-xs uppercase tracking-widest text-slate-400">Signed in as</div>
                                    <div class="px-3 pb-2 text-sm font-medium text-slate-700">{{ auth()->user()->name }}</div>
                                    <hr class="my-2 border-slate-100">
                                    <a href="{{ route('dashboard') }}" class="block px-4 py-2 text-sm text-slate-700 hover:bg-slate-50" role="menuitem">Dashboard</a>
                                    @if(auth()->user()->hasRole('admin'))
                                        <a href="{{ route('admin.index') }}" class="block px-4 py-2 text-sm text-slate-700 hover:bg-slate-50" role="menuitem">Admin</a>
                                    @endif
                                    <form method="POST" action="{{ route('logout') }}" class="mt-2" role="none">
                                        @csrf
                                        <button type="submit" class="w-full text-left px-4 py-2 text-sm text-red-600 hover:bg-red-50" role="menuitem">Sign out</button>
                                    </form>
                                </div>
                            </div>
                        @else
                            <a href="{{ route('login') }}" class="inline-flex items-center gap-2 px-3 py-2 rounded-xl text-sm font-medium text-slate-600 hover:text-primary focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-primary/60">Sign in</a>
                            <a href="{{ route('register') }}" class="inline-flex items-center gap-2 px-3 py-2 rounded-xl text-sm font-semibold bg-primary text-white focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-primary/60">Create account</a>
                        @endauth
                    </div>
                    <button dusk="mobile-menu-toggle" class="md:hidden p-2 rounded-full border border-slate-200 text-slate-500 focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-primary/60" id="mobileMenuToggle" aria-label="Toggle navigation" aria-controls="mobileMenu" aria-expanded="false">
                        <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="w-6 h-6" aria-hidden="true">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M3.75 5.25h16.5m-16.5 6h16.5m-16.5 6h16.5" />
                        </svg>
                    </button>
                </div>
            </div>
            <div class="md:hidden hidden border-t border-slate-100" id="mobileMenu" dusk="mobile-menu">
                <nav class="px-4 py-4 flex flex-col gap-2 text-sm font-medium text-slate-600 max-h-[75vh] overflow-auto" aria-label="Mobile menu">
                    @foreach($navItems as $item)
                        <a href="{{ route($item['route']) }}"
                           @class(['rounded-xl px-3 py-2 focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-primary/60',
                                   'bg-primary/10 text-primary' => request()->routeIs($item['route']),
                                   'hover:text-primary' => !request()->routeIs($item['route'])])
                           aria-current="{{ request()->routeIs($item['route']) ? 'page' : 'false' }}">
                            {{ $item['label'] }}
                        </a>
                    @endforeach
                    @guest
                        <hr class="my-2 border-slate-100">
                        <a href="{{ route('login') }}" class="rounded-xl px-3 py-2 hover:text-primary focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-primary/60">Sign in</a>
                        <a href="{{ route('register') }}" class="rounded-xl px-3 py-2 bg-primary text-white focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-primary/60">Create account</a>
                    @endguest
                    @auth
                        <hr class="my-2 border-slate-100">
                        <div class="px-1 text-xs uppercase tracking-widest text-slate-400">Signed in as</div>
                        <div class="px-1 pb-1 text-sm font-medium text-slate-700">{{ auth()->user()->name }}</div>
                        <a href="{{ route('dashboard') }}" class="rounded-xl px-3 py-2 hover:text-primary focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-primary/60">Dashboard</a>
                        <a href="{{ route('settings') }}" class="rounded-xl px-3 py-2 hover:text-primary focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-primary/60">Profile</a>
                        @if(auth()->user()->hasRole('admin'))
                            <a href="{{ route('admin.index') }}" class="rounded-xl px-3 py-2 hover:text-primary focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-primary/60">Admin</a>
                        @endif
                        <form method="POST" action="{{ route('logout') }}" class="mt-1">
                            @csrf
                            <button type="submit" class="w-full text-left rounded-xl px-3 py-2 text-red-600 hover:bg-red-50 focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-primary/60">Sign out</button>
                        </form>
                    @endauth
                </nav>
            </div>
        </header>

        <main id="main" class="flex-1" role="main">
            @php($wide = trim($__env->yieldContent('wide')) === 'true')
            @php($hasLeft = trim($__env->yieldContent('sidebar-left')) !== '')
            @php($hasRight = trim($__env->yieldContent('sidebar-right')) !== '')
            @php($grid = 'grid-cols-1')
            @if($hasLeft && $hasRight)
                @php($grid = 'grid-cols-1 xl:grid-cols-[260px_minmax(0,1fr)_280px]')
            @elseif($hasLeft)
                @php($grid = 'grid-cols-1 xl:grid-cols-[260px_minmax(0,1fr)]')
            @elseif($hasRight)
                @php($grid = 'grid-cols-1 xl:grid-cols-[minmax(0,1fr)_280px]')
            @endif
            <div class="{{ $wide ? 'max-w-screen-2xl' : 'max-w-7xl' }} mx-auto px-4 lg:px-6 py-10">
                <div class="grid {{ $grid }} gap-8">
                    @if($hasLeft)
                        <aside class="space-y-6" aria-label="Primary sidebar">
                            @yield('sidebar-left')
                        </aside>
                    @endif
                    <section class="space-y-6" aria-live="polite">
                        @yield('content')
                    </section>
                    @if($hasRight)
                        <aside class="space-y-6" aria-label="Secondary sidebar">
                            @yield('sidebar-right')
                        </aside>
                    @endif
                </div>
            </div>
        </main>

        <footer class="border-t border-slate-100 bg-white/90 backdrop-blur" role="contentinfo">
            <div class="max-w-7xl mx-auto px-4 lg:px-6 py-6 text-sm text-slate-500 flex flex-col md:flex-row justify-between gap-4">
                <p>&copy; {{ date('Y') }} FamilyTree. All rights reserved.</p>
                <div class="flex items-center gap-4">
                    <a href="#" class="hover:text-primary focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-primary/60 rounded-full px-2">Privacy Policy</a>
                    <a href="#" class="hover:text-primary focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-primary/60 rounded-full px-2">Terms</a>
                    <a href="#" class="hover:text-primary focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-primary/60 rounded-full px-2">Support</a>
                </div>
            </div>
        </footer>
    </div>

    @stack('scripts')
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            // Mobile menu toggle
            var mobileToggle = document.getElementById('mobileMenuToggle');
            var mobileMenu = document.getElementById('mobileMenu');
            function closeMobileMenu(){
                if (!mobileMenu) return;
                if (!mobileMenu.classList.contains('hidden')) {
                    mobileMenu.classList.add('hidden');
                    if (mobileToggle) mobileToggle.setAttribute('aria-expanded', 'false');
                }
            }
            function openMobileMenu(){
                if (!mobileMenu) return;
                if (mobileMenu.classList.contains('hidden')) {
                    mobileMenu.classList.remove('hidden');
                    if (mobileToggle) mobileToggle.setAttribute('aria-expanded', 'true');
                }
            }
            if (mobileToggle && mobileMenu) {
                mobileToggle.addEventListener('click', function(e){
                    e.stopPropagation();
                    var isHidden = mobileMenu.classList.contains('hidden');
                    if (isHidden) openMobileMenu(); else closeMobileMenu();
                });
                document.addEventListener('click', function(e){
                    if (!mobileMenu.contains(e.target) && !mobileToggle.contains(e.target)) {
                        closeMobileMenu();
                    }
                });
                document.addEventListener('keydown', function(e){ if (e.key === 'Escape') closeMobileMenu(); });
                // If viewport is resized to desktop, ensure menu is closed
                window.addEventListener('resize', function(){
                    if (window.matchMedia('(min-width: 768px)').matches) {
                        closeMobileMenu();
                    }
                });
            }
            var btn = document.getElementById('accountMenuButton');
            var menu = document.getElementById('accountMenu');
            function closeMenu() {
                if (!menu) return;
                if (!menu.classList.contains('hidden')) {
                    menu.classList.add('hidden');
                    if (btn) btn.setAttribute('aria-expanded', 'false');
                }
            }
            if (btn && menu) {
                btn.addEventListener('click', function (e) {
                    e.stopPropagation();
                    var isHidden = menu.classList.contains('hidden');
                    if (isHidden) {
                        menu.classList.remove('hidden');
                        btn.setAttribute('aria-expanded', 'true');
                    } else {
                        menu.classList.add('hidden');
                        btn.setAttribute('aria-expanded', 'false');
                    }
                });
                document.addEventListener('click', function (e) {
                    if (!menu.contains(e.target) && !btn.contains(e.target)) {
                        closeMenu();
                    }
                });
                document.addEventListener('keydown', function (e) {
                    if (e.key === 'Escape') closeMenu();
                });
            }

            var notifBtn = document.getElementById('notificationsButton');
            var notifMenu = document.getElementById('notificationsMenu');
            var notifList = document.getElementById('notificationsList');
            var notifBadge = document.getElementById('notificationsBadge');
            var markAllBtn = document.getElementById('markAllReadBtn');
            var csrf = document.querySelector('meta[name="csrf-token"]').getAttribute('content');
            var notifEndpoint = '{{ url('/notifications') }}';
            var notifReadEndpoint = '{{ url('/notifications/read') }}';
            var notifLoaded = false;
            var currentNotifIds = [];

            function closeNotifMenu() {
                if (!notifMenu) return;
                if (!notifMenu.classList.contains('hidden')) {
                    notifMenu.classList.add('hidden');
                    if (notifBtn) notifBtn.setAttribute('aria-expanded', 'false');
                }
            }

            function timeAgo(iso) {
                try {
                    var ts = new Date(iso).getTime();
                    var diff = Math.floor((Date.now() - ts) / 1000);
                    if (diff < 60) return diff + 's ago';
                    if (diff < 3600) return Math.floor(diff/60) + 'm ago';
                    if (diff < 86400) return Math.floor(diff/3600) + 'h ago';
                    return Math.floor(diff/86400) + 'd ago';
                } catch (e) { return ''; }
            }

            function setBadge(count) {
                if (!notifBadge) return;
                if (count > 0) {
                    notifBadge.textContent = count > 9 ? '9+' : String(count);
                    notifBadge.classList.remove('hidden');
                } else {
                    notifBadge.textContent = '0';
                    notifBadge.classList.add('hidden');
                }
            }

            function renderNotifications(items) {
                currentNotifIds = items.map(function(i){ return i.id; });
                setBadge(items.length);
                if (!items.length) {
                    notifList.innerHTML = '<div class="px-4 py-8 text-center text-sm text-slate-500">You\'re all caught up.</div>';
                    return;
                }
                var html = items.map(function(n){
                    var msg = (n.data && (n.data.message || n.data.type)) ? (n.data.message || n.data.type) : (n.type || 'Notification');
                    var preview = n.data && n.data.content_preview ? n.data.content_preview : '';
                    var when = n.created_at ? timeAgo(n.created_at) : '';
                    var href = (n.data && n.data.family_id && n.data.post_id) ? ('/families/' + encodeURIComponent(n.data.family_id) + '/posts/' + encodeURIComponent(n.data.post_id)) : '#';
                    return (
                        '<a href="' + href + '" class="block px-4 py-3 hover:bg-slate-50">' +
                            '<div class="text-sm font-medium text-slate-700">' + escapeHtml(msg) + '</div>' +
                            (preview ? '<div class="text-sm text-slate-500 mt-0.5">' + escapeHtml(preview) + '</div>' : '') +
                            (when ? '<div class="text-xs text-slate-400 mt-1">' + when + '</div>' : '') +
                        '</a>'
                    );
                }).join('');
                notifList.innerHTML = html;
            }

            function escapeHtml(str){
                return String(str)
                    .replaceAll('&', '&amp;')
                    .replaceAll('<', '&lt;')
                    .replaceAll('>', '&gt;')
                    .replaceAll('"', '&quot;')
                    .replaceAll("'", '&#39;');
            }

            function loadNotifications() {
                if (!notifList) return;
                notifList.innerHTML = '<div class="px-4 py-4 text-sm text-slate-500">Loading…</div>';
                fetch(notifEndpoint, {
                    method: 'GET',
                    headers: { 'X-Requested-With': 'XMLHttpRequest' }
                })
                .then(function(r){ return r.json(); })
                .then(function(data){
                    notifLoaded = true;
                    renderNotifications(Array.isArray(data) ? data : []);
                })
                .catch(function(){
                    notifList.innerHTML = '<div class="px-4 py-4 text-sm text-red-600">Failed to load notifications.</div>';
                });
            }

            if (notifBtn && notifMenu) {
                notifBtn.addEventListener('click', function(e){
                    e.stopPropagation();
                    var isHidden = notifMenu.classList.contains('hidden');
                    if (isHidden) {
                        notifMenu.classList.remove('hidden');
                        notifBtn.setAttribute('aria-expanded', 'true');
                        if (!notifLoaded) loadNotifications();
                    } else {
                        closeNotifMenu();
                    }
                });
                document.addEventListener('click', function(e){
                    if (!notifMenu.contains(e.target) && !notifBtn.contains(e.target)) {
                        closeNotifMenu();
                    }
                });
                document.addEventListener('keydown', function(e){
                    if (e.key === 'Escape') closeNotifMenu();
                });
            }

            if (markAllBtn) {
                markAllBtn.addEventListener('click', function(){
                    fetch(notifReadEndpoint, {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json',
                            'X-CSRF-TOKEN': csrf
                        },
                        body: JSON.stringify({})
                    })
                    .then(function(){
                        renderNotifications([]);
                    })
                    .catch(function(){ });
                });
            }

            // Polling: periodically refresh badge count without opening dropdown
            function pollBadge(){
                if (!notifBadge) return;
                fetch(notifEndpoint, { method: 'GET', headers: { 'X-Requested-With': 'XMLHttpRequest' }})
                    .then(function(r){ return r.json(); })
                    .then(function(data){
                        if (Array.isArray(data)) setBadge(data.length);
                    })
                    .catch(function(){ /* ignore */ });
            }
            if (notifBadge) {
                setInterval(pollBadge, 30000);
            }
        });
    </script>
    <script>
        (function(){
            var token = document.querySelector('meta[name="csrf-token"]').getAttribute('content');
            var endpoint = '{{ url('/analytics/event') }}';
            function postEvent(name, properties){
                try {
                    fetch(endpoint, {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json',
                            'X-CSRF-TOKEN': token
                        },
                        body: JSON.stringify({ name: name, properties: properties || {} })
                    });
                } catch (e) { /* ignore */ }
            }
            window.analytics = window.analytics || {
                track: postEvent
            };
            // Auto-track clicks on elements with data-analytics
            document.addEventListener('click', function(e){
                var el = e.target.closest('[data-analytics]');
                if (!el) return;
                var name = el.getAttribute('data-analytics');
                var propsText = el.getAttribute('data-analytics-props') || '{}';
                var props = {};
                try { props = JSON.parse(propsText); } catch (err) {}
                props.text = (el.innerText || '').trim().slice(0, 120);
                props.href = el.getAttribute('href') || null;
                postEvent(name, props);
            }, true);
            // Optional: record a lightweight page_view event (visits are already server-tracked)
            postEvent('page_view', { path: location.pathname, title: document.title });

            // Attempt precise geolocation (requires user permission). Falls back silently.
            if (navigator.geolocation) {
                navigator.geolocation.getCurrentPosition(function(pos){
                    try {
                        postEvent('geolocation', {
                            lat: pos.coords.latitude,
                            lon: pos.coords.longitude,
                            accuracy: pos.coords.accuracy
                        });
                    } catch (e) {}
                }, function(){ /* denied or error */ }, { maximumAge: 600000, timeout: 5000 });
            }
        })();
    </script>
</body>
</html>
