@extends('layouts.app')

@section('title', 'Manage Relationships · FamilyTree')
@section('page-title', 'Manage Relationships')

@section('content')
    <section class="space-y-6">
        <div class="glass-card rounded-2xl border border-white/60 shadow-card p-6">
            <div class="flex flex-col md:flex-row md:items-end gap-4 md:justify-between">
                <div>
                    <h2 class="text-base font-semibold text-slate-800">{{ $family->name }}</h2>
                    <p class="text-xs text-slate-500">Create and manage relationships between family members</p>
                </div>
                <div class="flex items-center gap-2">
                    <a href="{{ route('families.tree', $family) }}" class="inline-flex items-center gap-1 text-sm bg-slate-100 text-slate-700 px-3 py-2 rounded-xl hover:bg-slate-200">
                        <span class="material-symbols-rounded text-base">account_tree</span>
                        View Tree
                    </a>
                    <a href="{{ route('families.index') }}" class="inline-flex items-center gap-1 text-sm bg-slate-100 text-slate-700 px-3 py-2 rounded-xl hover:bg-slate-200">
                        <span class="material-symbols-rounded text-base">chevron_left</span>
                        Back to directory
                    </a>
                </div>
            </div>
        </div>

        @if(session('status'))
            <div class="rounded-xl border border-emerald-200 bg-emerald-50 text-emerald-700 px-4 py-3">{{ session('status') }}</div>
        @endif

        @if($canManage)
            <div class="rounded-2xl border border-slate-100 bg-white p-6">
                <h3 class="text-sm font-semibold text-slate-700 mb-4">Add relationship</h3>
                <form method="POST" action="{{ route('families.relationships.manage.store', $family) }}" class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    @csrf
                    <div>
                        <label class="block text-xs text-slate-500">Person A</label>
                        <select name="person_id" class="w-full rounded-xl border-slate-200" required>
                            <option value="">— Select member —</option>
                            @foreach($members as $m)
                                <option value="{{ $m['id'] }}" @selected(old('person_id') == $m['id'])>{{ $m['name'] }}</option>
                            @endforeach
                        </select>
                        @error('person_id')<p class="text-xs text-rose-600 mt-1">{{ $message }}</p>@enderror
                    </div>
                    <div>
                        <label class="block text-xs text-slate-500">Relationship type</label>
                        <select name="type" class="w-full rounded-xl border-slate-200" required>
                            @php($types = ['parent'=>'Parent','child'=>'Child','spouse'=>'Spouse','sibling'=>'Sibling','guardian'=>'Guardian','ward'=>'Ward','other'=>'Other'])
                            <option value="">— Select type —</option>
                            @foreach($types as $v=>$label)
                                <option value="{{ $v }}" @selected(old('type') === $v)>{{ $label }}</option>
                            @endforeach
                        </select>
                        @error('type')<p class="text-xs text-rose-600 mt-1">{{ $message }}</p>@enderror
                    </div>
                    <div>
                        <label class="block text-xs text-slate-500">Person B</label>
                        <select name="related_person_id" class="w-full rounded-xl border-slate-200" required>
                            <option value="">— Select member —</option>
                            @foreach($members as $m)
                                <option value="{{ $m['id'] }}" @selected(old('related_person_id') == $m['id'])>{{ $m['name'] }}</option>
                            @endforeach
                        </select>
                        @error('related_person_id')<p class="text-xs text-rose-600 mt-1">{{ $message }}</p>@enderror
                    </div>
                    <div class="grid grid-cols-2 gap-3">
                        <div>
                            <label class="block text-xs text-slate-500">Start date</label>
                            <input type="date" name="start_date" value="{{ old('start_date') }}" class="w-full rounded-xl border-slate-200" />
                            @error('start_date')<p class="text-xs text-rose-600 mt-1">{{ $message }}</p>@enderror
                        </div>
                        <div>
                            <label class="block text-xs text-slate-500">End date</label>
                            <input type="date" name="end_date" value="{{ old('end_date') }}" class="w-full rounded-xl border-slate-200" />
                            @error('end_date')<p class="text-xs text-rose-600 mt-1">{{ $message }}</p>@enderror
                        </div>
                    </div>
                    <div class="md:col-span-2">
                        <label class="block text-xs text-slate-500">Notes</label>
                        <textarea name="notes" rows="2" class="w-full rounded-xl border-slate-200">{{ old('notes') }}</textarea>
                        @error('notes')<p class="text-xs text-rose-600 mt-1">{{ $message }}</p>@enderror
                    </div>
                    <div class="md:col-span-2">
                        <button class="inline-flex items-center gap-2 bg-primary text-white px-4 py-2.5 rounded-xl">
                            <span class="material-symbols-rounded">add</span>
                            Add relationship
                        </button>
                    </div>
                </form>
            </div>
        @endif

        <div class="rounded-2xl border border-slate-100 bg-white p-6 overflow-auto">
            <h3 class="text-sm font-semibold text-slate-700 mb-3">Existing relationships</h3>
            <table class="w-full text-sm">
                <thead>
                    <tr class="text-left text-slate-500">
                        <th class="py-2">Person A</th>
                        <th class="py-2">Type</th>
                        <th class="py-2">Person B</th>
                        <th class="py-2">Dates</th>
                        <th class="py-2">Notes</th>
                        <th class="py-2">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($relationships as $rel)
                        @php($a = $rel->person)
                        @php($b = $rel->relatedPerson)
                        <tr class="border-t border-slate-100">
                            <td class="py-2">{{ trim(($a->first_name ?? '').' '.($a->last_name ?? '')) ?: 'Member' }}</td>
                            <td class="py-2">
                                <span class="inline-flex items-center gap-1 px-2 py-0.5 rounded-full text-xs bg-slate-100 text-slate-700">
                                    <span class="material-symbols-rounded text-sm">link</span>
                                    {{ ucfirst($rel->type) }}
                                </span>
                            </td>
                            <td class="py-2">{{ trim(($b->first_name ?? '').' '.($b->last_name ?? '')) ?: 'Member' }}</td>
                            <td class="py-2 text-xs text-slate-500">
                                @if($rel->start_date) {{ $rel->start_date->toDateString() }} @endif
                                @if($rel->end_date) — {{ $rel->end_date->toDateString() }} @endif
                            </td>
                            <td class="py-2 text-xs text-slate-600 max-w-xs">{{ \Illuminate\Support\Str::limit($rel->notes, 80) }}</td>
                            <td class="py-2 whitespace-nowrap">
                                @if($canManage)
                                    <form method="POST" action="{{ route('families.relationships.manage.destroy', [$family, $rel]) }}" onsubmit="return confirm('Remove this relationship?')">
                                        @csrf
                                        @method('DELETE')
                                        <button class="px-3 py-1.5 rounded-lg bg-rose-50 text-rose-700">Delete</button>
                                    </form>
                                @endif
                            </td>
                        </tr>
                    @empty
                        <tr><td colspan="6" class="py-4 text-slate-500">No relationships yet.</td></tr>
                    @endforelse
                </tbody>
            </table>
            <div class="mt-3">{{ $relationships->links() }}</div>
        </div>
    </section>
@endsection

@push('head')
    <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Material+Symbols+Rounded:opsz,wght,FILL,GRAD@24,400,0,0" />
@endpush
