@extends('layouts.app')

@section('title', 'Analytics · FamilyTree')
@section('page-title', 'Analytics Overview')

@section('sidebar-left')
    <div class="glass-card rounded-2xl border border-white/50 shadow-card p-6 space-y-4">
        <header>
            <h2 class="text-sm font-semibold text-slate-500 uppercase tracking-wide">Highlights</h2>
            <p class="text-xs text-slate-400">Snapshot of platform-wide engagement for the past 30 days.</p>
        </header>
        <ul class="space-y-3 text-sm text-slate-600">
            <li class="flex items-start gap-3">
                <span class="material-symbols-rounded text-primary">diversity_3</span>
                <span>Families created and active relationships are tracked to spot growth.</span>
            </li>
            <li class="flex items-start gap-3">
                <span class="material-symbols-rounded text-primary">dynamic_feed</span>
                <span>Activity feed surfaces key moments (invitations, subscriptions, wall posts).</span>
            </li>
            <li class="flex items-start gap-3">
                <span class="material-symbols-rounded text-primary">hub</span>
                <span>Relationship breakdown helps understand which connections resonate most.</span>
            </li>
        </ul>
    </div>

    <div class="glass-card rounded-2xl border border-white/50 shadow-card p-6 space-y-4">
        <header>
            <h2 class="text-sm font-semibold text-slate-500 uppercase tracking-wide">Data freshness</h2>
            <p class="text-xs text-slate-400">Analytics update every time an activity log is recorded.</p>
        </header>
        <p class="text-xs text-slate-500">Use the detailed reports in the right sidebar to audit recent activity without leaving this dashboard.</p>
    </div>
@endsection

@section('content')
    <div class="space-y-6">
        <section>
            <div class="grid grid-cols-1 md:grid-cols-2 xl:grid-cols-4 gap-4">
                @foreach($overview as $metric)
                    <article class="glass-card rounded-2xl border border-white/60 shadow-card p-6">
                        <header class="flex items-center justify-between">
                            <div>
                                <h3 class="text-xs uppercase tracking-wide text-slate-400">{{ $metric['label'] }}</h3>
                                <p class="mt-2 text-2xl font-semibold text-slate-800">{{ $metric['value'] }}</p>
                            </div>
                            <span class="material-symbols-rounded text-primary text-3xl" aria-hidden="true">{{ $metric['icon'] }}</span>
                        </header>
                        <p class="mt-4 text-xs text-slate-500">{{ $metric['delta'] }}</p>
                    </article>
                @endforeach
            </div>
        </section>

        <section class="grid grid-cols-1 xl:grid-cols-2 gap-6">
            <article class="glass-card rounded-2xl border border-white/60 shadow-card p-6">
                <header class="flex items-center justify-between">
                    <div>
                        <h2 class="text-lg font-semibold text-slate-800">Daily Activity</h2>
                        <p class="text-sm text-slate-500">Events captured in the past two weeks</p>
                    </div>
                </header>
                <div class="mt-6 space-y-4">
                    @foreach($dailyActivity as $point)
                        @php($width = min(100, max(6, $point['value'] * 4)))
                        <div>
                            <div class="flex items-center justify-between text-sm text-slate-600">
                                <span>{{ $point['label'] }}</span>
                                <span class="font-semibold text-slate-800">{{ $point['value'] }}</span>
                            </div>
                            <div class="mt-2 h-2 rounded-full bg-slate-200">
                                <div class="h-2 rounded-full bg-primary transition-all" style="width: {{ $width }}%"></div>
                            </div>
                        </div>
                    @endforeach
                </div>
            </article>

            <article class="glass-card rounded-2xl border border-white/60 shadow-card p-6">
                <header class="flex items-center justify-between">
                    <div>
                        <h2 class="text-lg font-semibold text-slate-800">Top Engaged Families</h2>
                        <p class="text-sm text-slate-500">Most active by membership and contributions</p>
                    </div>
                </header>
                <div class="overflow-x-auto mt-6">
                    <table class="min-w-full text-left text-sm text-slate-600">
                        <thead class="text-xs uppercase text-slate-400 border-y border-slate-200/60">
                            <tr>
                                <th class="px-4 py-3">Family</th>
                                <th class="px-4 py-3">Members</th>
                                <th class="px-4 py-3">Posts</th>
                                <th class="px-4 py-3">Posts · 30d</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-slate-200/70">
                            @forelse($engagementLeaders as $family)
                                <tr class="hover:bg-primary/5">
                                    <td class="px-4 py-3 font-medium text-slate-800">{{ $family['name'] }}</td>
                                    <td class="px-4 py-3">{{ $family['members'] }}</td>
                                    <td class="px-4 py-3">{{ $family['posts'] }}</td>
                                    <td class="px-4 py-3">{{ $family['recent_posts'] }}</td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="4" class="px-4 py-6 text-center text-sm text-slate-400">No families recorded yet.</td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </article>
        </section>

        <section class="grid grid-cols-1 xl:grid-cols-3 gap-6">
            <article class="xl:col-span-2 glass-card rounded-2xl border border-white/60 shadow-card p-6">
                <header class="flex items-center justify-between">
                    <div>
                        <h2 class="text-lg font-semibold text-slate-800">Relationship Breakdown</h2>
                        <p class="text-sm text-slate-500">Types of connections across the network</p>
                    </div>
                </header>
                <div class="mt-6 space-y-4">
                    @forelse($relationshipBreakdown as $relationship)
                        @php($width = min(100, max(6, $relationship['count'] * 3)))
                        <div>
                            <div class="flex items-center justify-between text-sm text-slate-600">
                                <span>{{ $relationship['type'] }}</span>
                                <span class="font-semibold text-slate-800">{{ number_format($relationship['count']) }}</span>
                            </div>
                            <div class="mt-2 h-2 rounded-full bg-slate-200">
                                <div class="h-2 rounded-full bg-emerald-400 transition-all" style="width: {{ $width }}%"></div>
                            </div>
                        </div>
                    @empty
                        <p class="text-sm text-slate-400">No relationship data captured yet.</p>
                    @endforelse
                </div>
            </article>

            <article class="glass-card rounded-2xl border border-white/60 shadow-card p-6">
                <header class="flex items-center justify-between">
                    <div>
                        <h2 class="text-lg font-semibold text-slate-800">Activity Feed</h2>
                        <p class="text-sm text-slate-500">Latest platform events</p>
                    </div>
                </header>
                <ul class="mt-6 space-y-4">
                    @forelse($activityFeed as $event)
                        <li class="flex items-start gap-3">
                            <span class="material-symbols-rounded text-primary">timeline</span>
                            <div>
                                <p class="text-sm font-medium text-slate-700">{{ $event['event'] }}</p>
                                <p class="text-xs text-slate-400">{{ $event['time'] }} • {{ $event['actor'] }}@if($event['family']) · {{ $event['family'] }}@endif</p>
                            </div>
                        </li>
                    @empty
                        <li class="text-sm text-slate-400">No activity yet. Start inviting family members!</li>
                    @endforelse
                </ul>
            </article>
        </section>
    </div>
@endsection

@section('sidebar-right')
    <div class="glass-card rounded-2xl border border-white/50 shadow-card p-6 space-y-4">
        <header>
            <h2 class="text-sm font-semibold text-slate-500 uppercase tracking-wide">Quick tips</h2>
            <p class="text-xs text-slate-400">Use these actions to boost engagement.</p>
        </header>
        <ul class="space-y-3 text-sm text-slate-600">
            <li class="flex items-start gap-3">
                <span class="material-symbols-rounded text-primary">mail</span>
                <span>Send follow-up invitations to members who have not accepted yet.</span>
            </li>
            <li class="flex items-start gap-3">
                <span class="material-symbols-rounded text-primary">notifications_active</span>
                <span>Encourage families to post stories and reactions to keep the feed lively.</span>
            </li>
            <li class="flex items-start gap-3">
                <span class="material-symbols-rounded text-primary">query_stats</span>
                <span>Review subscription conversions on the Subscriptions page for revenue insights.</span>
            </li>
        </ul>
    </div>

    <div class="glass-card rounded-2xl border border-white/50 shadow-card p-6 space-y-4">
        <header>
            <h2 class="text-sm font-semibold text-slate-500 uppercase tracking-wide">Exports</h2>
            <p class="text-xs text-slate-400">Data exports arrive via email as CSV attachments.</p>
        </header>
        <button class="inline-flex items-center gap-2 text-sm font-semibold text-primary hover:text-primary/80 focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-primary/60 rounded-full px-4 py-2 border border-primary/40">
            <span class="material-symbols-rounded text-base">download</span>
            Request latest export
        </button>
        <p class="text-xs text-slate-400">Exports include families, members, subscriptions, and invitations data.</p>
    </div>
@endsection

@push('head')
    <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Material+Symbols+Rounded:opsz,wght,FILL,GRAD@24,400,0,0" />
@endpush
