@extends('layouts.app')

@section('title', 'Users · Admin · FamilyTree')
@section('page-title', 'Users Management')
@section('wide', 'true')

@section('content')
    <section class="space-y-6">
        @if (session('status'))
            <div class="rounded-xl bg-green-50 border border-green-200 text-green-800 px-4 py-3">{{ session('status') }}</div>
        @endif

        <div class="glass-card rounded-2xl border border-white/60 shadow-card p-6">
            <form method="GET" action="{{ route('admin.users.index') }}" class="flex items-center gap-3">
                <input type="text" name="search" value="{{ $search }}" placeholder="Search name or email…" class="flex-1 rounded-xl border border-slate-200 px-3 py-2" />
                <button type="submit" class="px-4 py-2 rounded-xl bg-primary text-white font-medium">Search</button>
                @if($search)
                    <a href="{{ route('admin.users.index') }}" class="px-3 py-2 rounded-xl border border-slate-200 text-slate-600">Clear</a>
                @endif
            </form>
        </div>

        <div class="glass-card rounded-2xl border border-white/60 shadow-card p-6 overflow-x-auto">
            <table class="min-w-full text-sm">
                <thead>
                    <tr class="text-left text-slate-500 border-b border-slate-100">
                        <th class="py-2 pr-4">Name</th>
                        <th class="py-2 pr-4">Email</th>
                        <th class="py-2 pr-4">Roles</th>
                        <th class="py-2 pr-4">Actions</th>
                    </tr>
                </thead>
                <tbody class="align-top">
                    @forelse($users as $user)
                        <tr class="border-b border-slate-100">
                            <td class="py-3 pr-4">
                                <div class="flex items-center gap-3">
                                    <img src="{{ $user?->person?->photo_url ?? 'https://ui-avatars.com/api/?name='.urlencode($user->name) }}" alt="{{ $user->name }}" class="h-8 w-8 rounded-full object-cover">
                                    <div>
                                        <div class="font-medium text-slate-800">{{ $user->name }}</div>
                                        <div class="text-xs text-slate-500">ID: {{ $user->id }}</div>
                                    </div>
                                </div>
                            </td>
                            <td class="py-3 pr-4">{{ $user->email }}</td>
                            <td class="py-3 pr-4">
                                <div class="flex flex-wrap gap-2">
                                    @forelse($user->roles as $role)
                                        <span class="inline-flex items-center px-2 py-1 rounded-full bg-slate-100 text-slate-700 text-xs">{{ $role->name }}</span>
                                    @empty
                                        <span class="text-xs text-slate-400">No role</span>
                                    @endforelse
                                </div>
                            </td>
                            <td class="py-3 pr-4">
                                <form action="{{ route('admin.users.roles.update', $user) }}" method="POST" class="flex items-center gap-2">
                                    @csrf
                                    @method('PATCH')
                                    <select name="roles[]" multiple size="3" class="rounded-xl border border-slate-200 px-2 py-1 text-sm min-w-[180px]">
                                        @foreach($roles as $role)
                                            <option value="{{ $role }}" @selected($user->roles->pluck('name')->contains($role))>{{ $role }}</option>
                                        @endforeach
                                    </select>
                                    <button type="submit" class="px-3 py-1.5 rounded-lg bg-primary text-white text-sm">Save</button>
                                </form>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="4" class="py-6 text-center text-slate-500">No users found.</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>

            <div class="mt-4">{{ $users->links() }}</div>
        </div>
    </section>
@endsection
