@extends('layouts.app')

@section('title', 'Locations · Admin · FamilyTree')
@section('page-title', 'Edit Country: ' . ($country['name'] ?? $code) . ' (' . $code . ')')
@section('wide', 'true')

@section('content')
    <section class="space-y-6">
        @if (session('status'))
            <div class="rounded-xl bg-green-50 border border-green-200 text-green-800 px-4 py-3">{{ session('status') }}</div>
        @endif
        @if ($errors->any())
            <div class="rounded-xl bg-red-50 border border-red-200 text-red-800 px-4 py-3">
                <ul class="list-disc list-inside">
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif

        <div class="flex items-center justify-between">
            <a href="{{ route('admin.locations.index') }}" class="text-sm text-slate-600 hover:text-primary">&larr; Back to Countries</a>
        </div>

        <div class="glass-card rounded-2xl border border-white/60 shadow-card p-6 space-y-4">
            <h2 class="text-lg font-semibold text-slate-800">Country</h2>
            <form action="{{ route('admin.locations.update', $code) }}" method="POST" class="grid md:grid-cols-3 gap-4">
                @csrf
                @method('PATCH')
                <div class="md:col-span-2">
                    <label for="name" class="block text-xs font-medium text-slate-500 mb-1">Country name</label>
                    <input type="text" id="name" name="name" value="{{ old('name', $country['name'] ?? $code) }}" class="w-full rounded-xl border border-slate-200 px-3 py-2" required>
                </div>
                <div class="md:col-span-1 flex items-end justify-end gap-2">
                    <button type="submit" class="px-4 py-2 rounded-xl bg-primary text-white font-medium">Save</button>
                </div>
            </form>
            <form action="{{ route('admin.locations.delete', $code) }}" method="POST" onsubmit="return confirm('Delete country {{ $country['name'] ?? $code }}? This cannot be undone.');" class="flex justify-end">
                @csrf
                @method('DELETE')
                <button type="submit" class="px-4 py-2 rounded-xl bg-red-50 text-red-600 border border-red-200 font-medium">Delete Country</button>
            </form>
        </div>

        <div class="glass-card rounded-2xl border border-white/60 shadow-card p-6 space-y-4">
            <div class="flex items-center justify-between">
                <h2 class="text-lg font-semibold text-slate-800">Regions</h2>
            </div>

            <div class="mt-2 grid gap-8 xl:grid-cols-2">
                @php($regions = $country['regions'] ?? [])
                @forelse($regions as $regionName => $region)
                    <div class="rounded-xl border border-slate-100 bg-white p-4 space-y-4">
                        <div class="flex items-center justify-between">
                            <h3 class="font-semibold text-slate-800">{{ $regionName }}</h3>
                            <form action="{{ route('admin.locations.region.delete', $code) }}" method="POST" onsubmit="return confirm('Delete region {{ $regionName }}?');">
                                @csrf
                                @method('DELETE')
                                <input type="hidden" name="region" value="{{ $regionName }}">
                                <button type="submit" class="px-3 py-1.5 rounded-lg bg-red-50 text-red-600 border border-red-200 text-xs">Delete</button>
                            </form>
                        </div>

                        <div class="space-y-3">
                            <div class="flex items-center justify-between">
                                <h4 class="text-sm font-medium text-slate-700">Districts</h4>
                                <form action="{{ route('admin.locations.district.add', $code) }}" method="POST" class="flex items-center gap-2">
                                    @csrf
                                    <input type="hidden" name="region" value="{{ $regionName }}">
                                    <input type="text" name="name" placeholder="New district" class="rounded-lg border border-slate-200 px-2 py-1 text-sm" required>
                                    <button type="submit" class="px-3 py-1.5 rounded-lg bg-primary text-white text-xs">Add</button>
                                </form>
                            </div>

                            @php($districts = $region['districts'] ?? [])
                            @forelse($districts as $districtName => $towns)
                                <div class="rounded-lg border border-slate-100 p-3">
                                    <div class="flex items-center justify-between">
                                        <div class="font-medium text-slate-800">{{ $districtName }}</div>
                                        <form action="{{ route('admin.locations.district.delete', $code) }}" method="POST" onsubmit="return confirm('Delete district {{ $districtName }}?');">
                                            @csrf
                                            @method('DELETE')
                                            <input type="hidden" name="region" value="{{ $regionName }}">
                                            <input type="hidden" name="district" value="{{ $districtName }}">
                                            <button type="submit" class="px-3 py-1.5 rounded-lg bg-red-50 text-red-600 border border-red-200 text-xs">Delete</button>
                                        </form>
                                    </div>

                                    <div class="mt-2">
                                        <div class="text-xs uppercase tracking-widest text-slate-400 mb-1">Towns</div>
                                        <div class="flex flex-wrap gap-2">
                                            @forelse($towns as $town)
                                                <form action="{{ route('admin.locations.town.delete', $code) }}" method="POST" onsubmit="return confirm('Remove town {{ $town }}?');" class="inline">
                                                    @csrf
                                                    @method('DELETE')
                                                    <input type="hidden" name="region" value="{{ $regionName }}">
                                                    <input type="hidden" name="district" value="{{ $districtName }}">
                                                    <input type="hidden" name="town" value="{{ $town }}">
                                                    <button type="submit" class="inline-flex items-center gap-1 px-2 py-1 rounded-full bg-slate-100 text-slate-700 text-xs">
                                                        <span>{{ $town }}</span>
                                                        <span aria-hidden>×</span>
                                                    </button>
                                                </form>
                                            @empty
                                                <div class="text-xs text-slate-500">No towns added yet.</div>
                                            @endforelse
                                        </div>

                                        <form action="{{ route('admin.locations.town.add', $code) }}" method="POST" class="mt-3 flex items-center gap-2">
                                            @csrf
                                            <input type="hidden" name="region" value="{{ $regionName }}">
                                            <input type="hidden" name="district" value="{{ $districtName }}">
                                            <input type="text" name="name" placeholder="New town" class="rounded-lg border border-slate-200 px-2 py-1 text-sm" required>
                                            <button type="submit" class="px-3 py-1.5 rounded-lg bg-primary text-white text-xs">Add Town</button>
                                        </form>
                                    </div>
                                </div>
                            @empty
                                <div class="text-sm text-slate-500">No districts in this region.</div>
                            @endforelse
                        </div>
                    </div>
                @empty
                    <div class="text-slate-500">No regions yet.</div>
                @endforelse

                <div class="rounded-xl border border-dashed border-slate-300 p-4">
                    <h3 class="font-semibold text-slate-800">Add Region</h3>
                    <form action="{{ route('admin.locations.region.add', $code) }}" method="POST" class="mt-2 flex items-center gap-2">
                        @csrf
                        <input type="text" name="name" placeholder="Region name" class="rounded-lg border border-slate-200 px-3 py-2" required>
                        <button type="submit" class="px-4 py-2 rounded-xl bg-primary text-white font-medium">Add</button>
                    </form>
                </div>
            </div>
        </div>
    </section>
@endsection
