@extends('layouts.app')

@section('title', 'Analytics · Admin · FamilyTree')
@section('page-title', 'Traffic Analytics')
@section('wide', 'true')

@section('content')
<section class="space-y-6">
    <form method="GET" class="glass-card rounded-2xl border border-white/60 shadow-card p-6 grid md:grid-cols-4 gap-4">
        <div>
            <label class="block text-xs text-slate-500 mb-1">From</label>
            <input type="date" name="from" value="{{ request('from', $from->toDateString()) }}" class="w-full rounded-xl border border-slate-200 px-3 py-2">
        </div>
        <div>
            <label class="block text-xs text-slate-500 mb-1">To</label>
            <input type="date" name="to" value="{{ request('to', $to->toDateString()) }}" class="w-full rounded-xl border border-slate-200 px-3 py-2">
        </div>
        <div class="md:col-span-2 flex items-end justify-end">
            <button class="px-4 py-2 rounded-xl bg-primary text-white">Apply</button>
        </div>
    </form>

    <div class="grid gap-6 md:grid-cols-2 xl:grid-cols-4">
        <div class="rounded-2xl border border-slate-100 bg-white p-6">
            <div class="text-xs uppercase tracking-widest text-slate-400">Visits</div>
            <div class="text-2xl font-semibold mt-1">{{ number_format($totals['visits']) }}</div>
        </div>
        <div class="rounded-2xl border border-slate-100 bg-white p-6">
            <div class="text-xs uppercase tracking-widest text-slate-400">Unique Sessions</div>
            <div class="text-2xl font-semibold mt-1">{{ number_format($totals['unique_sessions']) }}</div>
        </div>
        <div class="rounded-2xl border border-slate-100 bg-white p-6">
            <div class="text-xs uppercase tracking-widest text-slate-400">Authenticated Users</div>
            <div class="text-2xl font-semibold mt-1">{{ number_format($totals['unique_users']) }}</div>
        </div>
    </div>

    <div class="grid gap-6 xl:grid-cols-2">
        <div class="rounded-2xl border border-slate-100 bg-white p-6">
            <div class="text-sm font-semibold text-slate-800 mb-2">Daily Visits</div>
            <div class="grid grid-cols-7 gap-1 items-end h-40">
                @foreach($daily as $row)
                    <div class="bg-primary/20" style="height: {{ max(4, $row['value']) * 2 }}px" title="{{ $row['label'] }}: {{ $row['value'] }}"></div>
                @endforeach
            </div>
            <div class="mt-2 flex justify-between text-xs text-slate-500">
                @if(count($daily))
                    <span>{{ $daily->first()['label'] }}</span>
                    <span>{{ $daily->last()['label'] }}</span>
                @endif
            </div>
        </div>
        <div class="rounded-2xl border border-slate-100 bg-white p-6">
            <div class="text-sm font-semibold text-slate-800 mb-2">Top Pages</div>
            <ul class="space-y-2">
                @foreach($topPages as $row)
                    <li class="flex justify-between text-sm"><span class="truncate max-w-[70%]">{{ $row->path }}</span><span class="text-slate-500">{{ $row->total }}</span></li>
                @endforeach
            </ul>
        </div>
    </div>

    <div class="grid gap-6 xl:grid-cols-3">
        <div class="rounded-2xl border border-slate-100 bg-white p-6">
            <div class="text-sm font-semibold text-slate-800 mb-2">Top Countries</div>
            <ul class="space-y-2">
                @foreach($topCountries as $row)
                    <li class="flex justify-between text-sm"><span>{{ $row->country }}</span><span class="text-slate-500">{{ $row->total }}</span></li>
                @endforeach
            </ul>
        </div>
        <div class="rounded-2xl border border-slate-100 bg-white p-6">
            <div class="text-sm font-semibold text-slate-800 mb-2">Devices</div>
            <ul class="space-y-2">
                @foreach($devices as $row)
                    <li class="flex justify-between text-sm"><span>{{ $row->device ?? 'Unknown' }}</span><span class="text-slate-500">{{ $row->total }}</span></li>
                @endforeach
            </ul>
        </div>
        <div class="rounded-2xl border border-slate-100 bg-white p-6">
            <div class="text-sm font-semibold text-slate-800 mb-2">Browsers</div>
            <ul class="space-y-2">
                @foreach($browsers as $row)
                    <li class="flex justify-between text-sm"><span>{{ $row->browser ?? 'Unknown' }}</span><span class="text-slate-500">{{ $row->total }}</span></li>
                @endforeach
            </ul>
        </div>
    </div>

    <div class="grid gap-6 xl:grid-cols-2">
        <div class="rounded-2xl border border-slate-100 bg-white p-6">
            <div class="text-sm font-semibold text-slate-800 mb-2">Recent Visits</div>
            <div class="overflow-x-auto">
                <table class="min-w-full text-sm">
                    <thead>
                        <tr class="text-left text-slate-500 border-b border-slate-100">
                            <th class="py-2 pr-4">Time</th>
                            <th class="py-2 pr-4">User</th>
                            <th class="py-2 pr-4">Path</th>
                            <th class="py-2 pr-4">IP</th>
                            <th class="py-2 pr-4">Country/City</th>
                            <th class="py-2 pr-4">Device</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($recentVisits as $v)
                            <tr class="border-b border-slate-100">
                                <td class="py-2 pr-4">{{ $v->created_at->diffForHumans() }}</td>
                                <td class="py-2 pr-4">{{ $v->user?->name ?? 'Guest' }}</td>
                                <td class="py-2 pr-4">{{ $v->path }}</td>
                                <td class="py-2 pr-4">{{ $v->ip }}</td>
                                <td class="py-2 pr-4">{{ $v->country ?? '—' }} / {{ $v->city ?? '—' }}</td>
                                <td class="py-2 pr-4">{{ $v->device ?? '—' }} • {{ $v->browser ?? '' }}</td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
            <div class="mt-3">{{ $recentVisits->links() }}</div>
        </div>
        <div class="rounded-2xl border border-slate-100 bg-white p-6">
            <div class="text-sm font-semibold text-slate-800 mb-2">Recent Events</div>
            <div class="overflow-x-auto">
                <table class="min-w-full text-sm">
                    <thead>
                        <tr class="text-left text-slate-500 border-b border-slate-100">
                            <th class="py-2 pr-4">Time</th>
                            <th class="py-2 pr-4">User</th>
                            <th class="py-2 pr-4">Event</th>
                            <th class="py-2 pr-4">Properties</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($recentEvents as $e)
                            <tr class="border-b border-slate-100">
                                <td class="py-2 pr-4">{{ $e->created_at->diffForHumans() }}</td>
                                <td class="py-2 pr-4">{{ $e->user?->name ?? 'Guest' }}</td>
                                <td class="py-2 pr-4">{{ $e->name }}</td>
                                <td class="py-2 pr-4 text-slate-500">
                                    <code class="text-xs">{{ json_encode($e->properties) }}</code>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
            <div class="mt-3">{{ $recentEvents->links() }}</div>
        </div>
    </div>
</section>
@endsection
