# Notification Strategy for Invitations

## Goals
- Deliver family invitations over both SMS and email using provider abstractions.
- Decouple transport details from domain logic via a notification gateway.
- Ensure asynchronous delivery with retries and observability hooks.

## Architecture Overview
```
app/
  Integrations/
    Notification/
      Contracts/
        SmsProvider.php
        EmailProvider.php
      Providers/
        MnotifySmsProvider.php
        MailEmailProvider.php
    NotificationGateway.php
  Jobs/
    SendInvitationNotifications.php
  Mail/
    InvitationEmail.php
  Services/
    InvitationService.php (dispatches notifications)
```

- `NotificationGateway` orchestrates outbound messaging using configured providers.
- Providers implement thin wrappers around transport SDKs / APIs.
- Queue job receives invitation payload and delegates to `NotificationGateway` for delivery.

## mNotify SMS Provider
- Configuration via `config/services.php` (`services.mnotify.api_key`, `sender_id`).
- Sends POST request to `https://api.mnotify.com/api/sms/quick` with recipients, sender, message.
- Handles HTTP failures with exceptions; integrates Laravel retry/backoff via queued job.

## Email Provider
- Leverages Laravel Mail facade with `InvitationEmail` mailable.
- Email provider interface keeps gateway abstract, enabling future providers (e.g., Postmark, SES).

## Invitation Flow Integration
1. Invitation created through `InvitationService`.
2. Service dispatches `SendInvitationNotifications` job with invitation ID + contact details.
3. Job loads invitation + family context, generates invite URL/token, calls gateway.
4. Gateway sends SMS (if phone present) and/or email (if email present).
5. Activity logging records dispatch success/failure; integration events table captures errors when applicable.

## Observability & Retry
- Queue job configured with retry/backoff (e.g., 5 tries with exponential delay).
- Failures logged and stored in `integration_events` for manual replay.
- Future enhancement: integrate metrics + circuit breaker toggles per provider.

## Next Steps
- Implement provider contracts + bindings (AppServiceProvider/IntegrationServiceProvider).
- Add environment variables for mNotify (API key, sender ID).
- Wire invitation workflow to enqueue notification job.
- Expand feature tests to cover notification dispatch side effects (activity logs, queued job assertion).
