<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('family_members', function (Blueprint $table) {
            if (!Schema::hasColumn('family_members', 'can_post_announcements')) {
                $table->boolean('can_post_announcements')->default(false)->after('role');
            }
            if (!Schema::hasColumn('family_members', 'can_create_events')) {
                $table->boolean('can_create_events')->default(false)->after('can_post_announcements');
            }
        });
    }

    public function down(): void
    {
        Schema::table('family_members', function (Blueprint $table) {
            if (Schema::hasColumn('family_members', 'can_create_events')) {
                $table->dropColumn('can_create_events');
            }
            if (Schema::hasColumn('family_members', 'can_post_announcements')) {
                $table->dropColumn('can_post_announcements');
            }
        });
    }
};
