<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('family_announcements', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('family_id');
            $table->unsignedBigInteger('created_by')->nullable();
            $table->string('title');
            $table->text('content');
            $table->boolean('send_to_all')->default(false);
            $table->timestamps();

            $table->foreign('family_id')->references('id')->on('families')->onDelete('cascade');
            $table->index(['family_id', 'created_at']);
        });

        Schema::create('family_announcement_recipients', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('announcement_id');
            $table->unsignedBigInteger('person_id');
            $table->timestamps();

            $table->foreign('announcement_id')->references('id')->on('family_announcements')->onDelete('cascade');
            $table->foreign('person_id')->references('id')->on('people')->onDelete('cascade');
            $table->unique(['announcement_id', 'person_id']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('family_announcement_recipients');
        Schema::dropIfExists('family_announcements');
    }
};
