<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('families', function (Blueprint $table) {
            if (!Schema::hasColumn('families', 'head_person_id')) {
                $table->unsignedBigInteger('head_person_id')->nullable()->after('clan_id');
                $table->foreign('head_person_id', 'fk_families_head_person_id')
                      ->references('id')->on('people')
                      ->nullOnDelete();
            }
        });
    }

    public function down(): void
    {
        Schema::table('families', function (Blueprint $table) {
            if (Schema::hasColumn('families', 'head_person_id')) {
                $table->dropForeign('fk_families_head_person_id');
                $table->dropColumn('head_person_id');
            }
        });
    }
};
