<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('clan_ethnic_group', function (Blueprint $table) {
            $table->unsignedBigInteger('clan_id');
            $table->unsignedBigInteger('ethnic_group_id');
            $table->primary(['clan_id', 'ethnic_group_id'], 'pk_clan_ethnic_group');
            $table->foreign('clan_id', 'fk_ceg_clan_id')->references('id')->on('clans')->cascadeOnDelete();
            $table->foreign('ethnic_group_id', 'fk_ceg_ethnic_group_id')->references('id')->on('ethnic_groups')->cascadeOnDelete();
        });

        // Backfill existing one-to-many assignments into the pivot
        if (Schema::hasColumn('clans', 'ethnic_group_id')) {
            $rows = DB::table('clans')->whereNotNull('ethnic_group_id')->get(['id', 'ethnic_group_id']);
            foreach ($rows as $row) {
                DB::table('clan_ethnic_group')->updateOrInsert(
                    ['clan_id' => $row->id, 'ethnic_group_id' => $row->ethnic_group_id],
                    []
                );
            }
        }
    }

    public function down(): void
    {
        Schema::dropIfExists('clan_ethnic_group');
    }
};
