<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('traffic_visits', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('session_id', 100)->nullable()->index();
            $table->foreignId('user_id')->nullable()->constrained()->nullOnDelete()->index();
            $table->string('ip', 45)->nullable()->index();
            $table->text('user_agent')->nullable();
            $table->string('device')->nullable();
            $table->string('platform')->nullable();
            $table->string('browser')->nullable();
            $table->string('method', 10)->nullable();
            $table->string('route_name')->nullable()->index();
            $table->string('path')->nullable()->index();
            $table->integer('status_code')->nullable()->index();
            $table->string('referrer')->nullable();
            $table->string('country')->nullable()->index();
            $table->string('city')->nullable()->index();
            $table->decimal('latitude', 10, 6)->nullable();
            $table->decimal('longitude', 10, 6)->nullable();
            $table->timestamps();
            $table->index(['created_at']);
        });

        Schema::create('traffic_events', function (Blueprint $table) {
            $table->bigIncrements('id');
            // Use explicit FK to avoid name collisions across schema; separate index is not necessary beyond FK index
            $table->unsignedBigInteger('visit_id')->nullable();
            $table->string('session_id', 100)->nullable()->index();
            $table->foreignId('user_id')->nullable()->constrained()->nullOnDelete();
            $table->string('name');
            $table->json('properties')->nullable();
            $table->timestamps();
            $table->index(['created_at']);

            $table->foreign('visit_id', 'fk_traffic_events_visit')
                ->references('id')->on('traffic_visits')
                ->cascadeOnDelete();
            $table->index('visit_id', 'idx_traffic_events_visit_id');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('traffic_events');
        Schema::dropIfExists('traffic_visits');
    }
};
