<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('people', function (Blueprint $table) {
            $table->boolean('is_memorialized')->default(false)->after('meta');
            $table->timestamp('memorialized_at')->nullable()->after('is_memorialized');
            $table->foreignId('memorialized_by')->nullable()->after('memorialized_at')->constrained('users')->nullOnDelete();
            $table->text('memorial_note')->nullable()->after('memorialized_by');
        });
    }

    public function down(): void
    {
        Schema::table('people', function (Blueprint $table) {
            $table->dropForeign(['memorialized_by']);
            $table->dropColumn([
                'is_memorialized',
                'memorialized_at',
                'memorialized_by',
                'memorial_note',
            ]);
        });
    }
};
