<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('invitations', function (Blueprint $table) {
            $table->id();
            $table->foreignId('family_id')->constrained('families')->cascadeOnDelete();
            $table->foreignId('inviter_user_id')->constrained('users')->cascadeOnDelete();
            $table->string('email')->nullable();
            $table->string('phone')->nullable();
            $table->string('token')->unique();
            $table->enum('status', ['pending','accepted','expired','revoked'])->default('pending');
            $table->timestamp('expires_at')->nullable();
            $table->foreignId('accepted_person_id')->nullable()->constrained('people')->nullOnDelete();
            $table->timestamps();
            $table->index(['family_id','status']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('invitations');
    }
};
