<?php

namespace Database\Factories;

use App\Models\Family;
use App\Models\FamilyWallPost;
use App\Models\User;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends Factory<FamilyWallPost>
 */
class FamilyWallPostFactory extends Factory
{
    protected $model = FamilyWallPost::class;

    public function definition(): array
    {
        return [
            'family_id' => Family::factory(),
            'author_id' => User::factory(),
            'content' => $this->faker->paragraph,
            'media' => null,
            'meta' => null,
        ];
    }
}
