<?php

use App\Integrations\Notification\Providers\LogSmsProvider;
use App\Integrations\Notification\Providers\MailEmailProvider;
use App\Integrations\Notification\Providers\MnotifySmsProvider;

return [
    'sms' => [
        'default' => env('NOTIFICATION_SMS_DRIVER', env('APP_ENV') === 'production' ? 'mnotify' : 'log'),

        'drivers' => [
            'mnotify' => [
                'class' => MnotifySmsProvider::class,
                'api_key' => env('MNOTIFY_API_KEY'),
                'sender_id' => env('MNOTIFY_SENDER_ID'),
                'base_url' => env('MNOTIFY_BASE_URL', 'https://api.mnotify.com'),
                // Optional HTTP client options
                'verify_ssl' => env('MNOTIFY_VERIFY_SSL', true),
                'timeout' => env('MNOTIFY_TIMEOUT', 30),
                'connect_timeout' => env('MNOTIFY_CONNECT_TIMEOUT', 10),
                'proxy' => env('MNOTIFY_PROXY'),
            ],

            'log' => [
                'class' => LogSmsProvider::class,
            ],
        ],
    ],

    'email' => [
        'default' => env('NOTIFICATION_EMAIL_DRIVER', 'mail'),

        'drivers' => [
            'mail' => [
                'class' => MailEmailProvider::class,
                'from_address' => env('MAIL_FROM_ADDRESS'),
                'from_name' => env('MAIL_FROM_NAME', env('APP_NAME', 'FamilyTree')),
            ],
        ],
    ],
];
