<?php

return [
    'default_driver' => env('BILLING_DRIVER', 'null'),

    'drivers' => [
        'null' => [
            'class' => App\Services\Billing\NullBillingProvider::class,
        ],
        'stripe' => [
            'class' => App\Services\Billing\StripeBillingProvider::class,
            'api_key' => env('STRIPE_SECRET'),
        ],
        'paystack' => [
            'class' => App\Services\Billing\PaystackBillingProvider::class,
            'secret_key' => env('PAYSTACK_SECRET'),
        ],
    ],
];
