<?php

namespace App\Support;

class Locations
{
    public static function all(): array
    {
        $path = storage_path('app/locations.json');
        if (is_file($path)) {
            $json = file_get_contents($path);
            $data = json_decode($json, true);
            if (is_array($data)) {
                return $data;
            }
        }
        return config('locations', []);
    }

    public static function save(array $locations): void
    {
        $path = storage_path('app/locations.json');
        file_put_contents($path, json_encode($locations, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
    }
}
