<?php

namespace App\Services\Billing;

use App\Contracts\Billing\BillingProvider;
use App\Models\Plan;
use Illuminate\Support\Str;

class NullBillingProvider implements BillingProvider
{
    public function __construct(private array $config = [])
    {
    }

    public function createCustomer(array $payload): array
    {
        return [
            'id' => Str::uuid()->toString(),
            'reference' => 'null_customer',
        ];
    }

    public function createSubscription(array $customer, Plan $plan, array $options = []): array
    {
        return [
            'id' => Str::uuid()->toString(),
            'plan_code' => $plan->code,
            'status' => 'active',
        ];
    }

    public function swapSubscription(array $subscription, Plan $plan, array $options = []): array
    {
        return [
            'id' => $subscription['id'] ?? Str::uuid()->toString(),
            'plan_code' => $plan->code,
            'status' => 'active',
        ];
    }

    public function cancelSubscription(array $subscription, bool $immediate = false): void
    {
        // No-op for null provider
    }

    public function createPaymentMethod(array $payload): array
    {
        return [
            'id' => Str::uuid()->toString(),
            'reference' => 'null_payment_method',
        ];
    }

    public function attachPaymentMethod(array $customer, array $method): void
    {
        // No-op
    }

    public function previewPlanChange(array $customer, Plan $plan, array $options = []): array
    {
        return [
            'plan_code' => $plan->code,
            'amount_cents' => $plan->price_cents,
            'currency' => $plan->currency,
            'proration_cents' => 0,
        ];
    }
}
