<?php

namespace App\Services\Billing;

use App\Contracts\Billing\BillingProvider;
use Illuminate\Contracts\Container\Container;
use Illuminate\Support\Arr;
use InvalidArgumentException;

class BillingManager
{
    public function __construct(private Container $container)
    {
    }

    public function driver(?string $name = null): BillingProvider
    {
        $name = $name ?? config('billing.default_driver', 'null');

        $config = config("billing.drivers.{$name}");

        if (!$config || !isset($config['class'])) {
            throw new InvalidArgumentException("Billing driver [{$name}] is not configured.");
        }

        $class = $config['class'];

        return $this->container->make($class, ['config' => $config]);
    }
}
