<?php

namespace App\Policies;

use App\Models\Family;
use App\Models\User;

class FamilySubscriptionPolicy
{
    public function viewSubscription(User $user, Family $family): bool
    {
        return $user->can('subscriptions.view') || $user->can('subscriptions.manage');
    }

    public function manageSubscription(User $user, Family $family): bool
    {
        return $user->can('subscriptions.manage');
    }
}
