<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Invitation extends Model
{
    use HasFactory;

    protected $fillable = [
        'family_id',
        'inviter_user_id',
        'email',
        'phone',
        'token',
        'status',
        'expires_at',
        'accepted_person_id',
    ];

    protected $casts = [
        'expires_at' => 'datetime',
    ];

    public function family()
    {
        return $this->belongsTo(Family::class);
    }

    public function inviter()
    {
        return $this->belongsTo(User::class, 'inviter_user_id');
    }

    public function acceptedPerson()
    {
        return $this->belongsTo(Person::class, 'accepted_person_id');
    }
}
