<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class FamilyWallPostComment extends Model
{
    use HasFactory;

    protected $fillable = [
        'family_wall_post_id',
        'user_id',
        'content',
        'meta',
    ];

    protected $casts = [
        'meta' => 'array',
    ];

    public function post()
    {
        return $this->belongsTo(FamilyWallPost::class, 'family_wall_post_id');
    }

    public function author()
    {
        return $this->belongsTo(User::class, 'user_id');
    }
}
