<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;

class FamilyAnnouncement extends Model
{
    use HasFactory;

    protected $fillable = [
        'family_id',
        'created_by',
        'title',
        'content',
        'send_to_all',
    ];

    protected $casts = [
        'send_to_all' => 'boolean',
    ];

    public function family(): BelongsTo
    {
        return $this->belongsTo(Family::class);
    }

    public function recipients(): BelongsToMany
    {
        return $this->belongsToMany(Person::class, 'family_announcement_recipients', 'announcement_id', 'person_id');
    }
}
