<?php

namespace App\Integrations\Notification\Providers;

use App\Integrations\Notification\Contracts\EmailProvider;
use Illuminate\Mail\MailManager;
use Illuminate\Support\Arr;
use Illuminate\Support\Facades\Mail;

class MailEmailProvider implements EmailProvider
{
    public function __construct(private array $config = [])
    {
    }

    public function send(string $to, string $subject, string $view, array $data = [], array $options = []): void
    {
        $fromAddress = Arr::get($this->config, 'from_address', config('mail.from.address'));
        $fromName = Arr::get($this->config, 'from_name', config('mail.from.name'));

        Mail::send($view, $data, function ($message) use ($to, $subject, $fromAddress, $fromName, $options) {
            if ($fromAddress) {
                $message->from($fromAddress, $fromName);
            }

            $message->to($to)->subject($subject);

            if (!empty($options['cc'])) {
                $message->cc($options['cc']);
            }

            if (!empty($options['bcc'])) {
                $message->bcc($options['bcc']);
            }

            if (!empty($options['reply_to'])) {
                $replyTo = $options['reply_to'];
                $message->replyTo($replyTo['address'], $replyTo['name'] ?? null);
            }
        });
    }
}
