<?php

namespace App\Http\Controllers;

use App\Models\Person;
use Illuminate\Http\Request;

class SettingsController extends Controller
{
    public function index(Request $request)
    {
        $person = $request->user()?->person;
        return view('settings.index', [ 'person' => $person ]);
    }

    public function updateProfile(Request $request)
    {
        $data = $request->validate([
            'first_name' => ['nullable','string','max:255'],
            'last_name' => ['nullable','string','max:255'],
            'bio' => ['nullable','string'],
            'photo_url' => ['nullable','url','max:2048'],
            'birth_date' => ['nullable','date'],
        ]);

        $user = $request->user();
        $person = $user->person;
        if (!$person) {
            $person = new Person();
            $person->user_id = $user->id;
        }

        $person->first_name = $data['first_name'] ?? $person->first_name;
        $person->last_name = $data['last_name'] ?? $person->last_name;
        $person->bio = $data['bio'] ?? $person->bio;
        if (array_key_exists('photo_url', $data)) { $person->photo_url = $data['photo_url']; }
        if (array_key_exists('birth_date', $data)) { $person->birth_date = $data['birth_date']; }
        $person->save();

        return redirect()->route('settings')->with('status', 'Profile updated.');
    }
}
