<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

class NotificationController extends Controller
{
    public function index(Request $request)
    {
        $notifications = $request->user()
            ->unreadNotifications()
            ->latest()
            ->take(20)
            ->get()
            ->map(function ($n) {
                return [
                    'id' => $n->id,
                    'type' => class_basename($n->type),
                    'data' => $n->data,
                    'read_at' => $n->read_at,
                    'created_at' => optional($n->created_at)->toIso8601String(),
                ];
            });

        return response()->json($notifications);
    }

    public function markAsRead(Request $request)
    {
        $data = $request->validate([
            'ids' => ['nullable','array'],
        ]);

        $query = $request->user()->unreadNotifications();
        if (!empty($data['ids'])) {
            $query->whereIn('id', $data['ids']);
        }
        $query->update(['read_at' => now()]);

        return response()->json(['status' => 'ok']);
    }
}
