<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\EthnicGroup;
use Illuminate\Http\Request;

class EthnicGroupController extends Controller
{
    public function index(Request $request)
    {
        $country = strtoupper((string) $request->query('country', ''));
        $query = EthnicGroup::query();
        if ($country !== '') {
            $query->where('country_code', $country);
        }
        $groups = $query->orderBy('country_code')->orderBy('name')->paginate(20);
        $countries = EthnicGroup::query()->select('country_code')->distinct()->orderBy('country_code')->pluck('country_code');

        return view('admin.ethnic-groups.index', compact('groups', 'countries', 'country'));
    }

    public function store(Request $request)
    {
        $data = $request->validate([
            'name' => ['required','string','max:255'],
            'country_code' => ['required','string','max:3'],
            'languages' => ['nullable','string','max:255'],
            'description' => ['nullable','string'],
        ]);
        EthnicGroup::create($data);
        return redirect()->route('admin.ethnic_groups.index');
    }

    public function update(Request $request, EthnicGroup $ethnicGroup)
    {
        $data = $request->validate([
            'name' => ['required','string','max:255'],
            'country_code' => ['required','string','max:3'],
            'languages' => ['nullable','string','max:255'],
            'description' => ['nullable','string'],
        ]);
        $ethnicGroup->update($data);
        return redirect()->route('admin.ethnic_groups.index');
    }

    public function destroy(Request $request, EthnicGroup $ethnicGroup)
    {
        $ethnicGroup->delete();
        return redirect()->route('admin.ethnic_groups.index');
    }
}
