<?php

namespace App\Contracts\Billing;

use App\Models\Plan;

interface BillingProvider
{
    public function createCustomer(array $payload): array;

    public function createSubscription(array $customer, Plan $plan, array $options = []): array;

    public function swapSubscription(array $subscription, Plan $plan, array $options = []): array;

    public function cancelSubscription(array $subscription, bool $immediate = false): void;

    public function createPaymentMethod(array $payload): array;

    public function attachPaymentMethod(array $customer, array $method): void;

    public function previewPlanChange(array $customer, Plan $plan, array $options = []): array;
}
